"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingMetricFactory = exports.BillingCurrency = exports.BillingRegion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
exports.BillingRegion = "us-east-1";
exports.BillingCurrency = "USD";
const BillingNamespace = "AWS/Billing";
const BillingMetric = "EstimatedCharges";
const BillingPeriod = aws_cdk_lib_1.Duration.days(1);
const DefaultServiceLimit = 10;
class BillingMetricFactory {
    metricSearchTopCostByServiceInUsd() {
        // standard MathExpression class does not support region
        // TODO: revisit after migration to CDK 1.126.0
        const search = new common_1.XaxrMathExpression({
            period: BillingPeriod,
            region: exports.BillingRegion,
            expression: `SEARCH('{${BillingNamespace},Currency,ServiceName} MetricName="${BillingMetric}"', 'Maximum', ${BillingPeriod.toSeconds()})`,
            usingMetrics: {},
            label: " ",
        });
        return new common_1.XaxrMathExpression({
            period: BillingPeriod,
            region: exports.BillingRegion,
            expression: `SORT(search, MAX, DESC, ${DefaultServiceLimit})`,
            usingMetrics: { search },
            label: " ",
        });
    }
    metricTotalCostInUsd() {
        // not using metric factory because we customize everything
        return new aws_cloudwatch_1.Metric({
            namespace: BillingNamespace,
            metricName: BillingMetric,
            dimensionsMap: { Currency: exports.BillingCurrency },
            period: BillingPeriod,
            label: `Estimated Charges`,
            region: exports.BillingRegion,
            statistic: common_1.MetricStatistic.MAX,
        });
    }
}
exports.BillingMetricFactory = BillingMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
BillingMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.BillingMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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