import { GraphWidget, IMetric, IWidget, SingleValueWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
export interface BillingMonitoringOptions extends BaseMonitoringProps {
}
export interface BillingMonitoringProps extends BillingMonitoringOptions {
}
export declare class BillingMonitoring extends Monitoring {
    private readonly title;
    protected readonly costByServiceMetric: IMetric;
    protected readonly totalCostMetric: IMetric;
    constructor(scope: MonitoringScope, props: BillingMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createChargesByServiceWidget(width: number, height: number): GraphWidget;
    protected createTotalChargesWidget(width: number, height: number): SingleValueWidget;
}
