"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const BillingMetricFactory_1 = require("./BillingMetricFactory");
class BillingMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const fallbackConstructName = aws_cdk_lib_1.Stack.of(scope).account;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        const metricFactory = new BillingMetricFactory_1.BillingMetricFactory();
        this.costByServiceMetric =
            metricFactory.metricSearchTopCostByServiceInUsd();
        this.totalCostMetric = metricFactory.metricTotalCostInUsd();
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTotalChargesWidget(common_1.FullWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createChargesByServiceWidget(common_1.ThreeQuartersWidth, common_1.DefaultGraphWidgetHeight),
            this.createTotalChargesWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "AWS Account Billing",
            title: this.title,
        });
    }
    createChargesByServiceWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Most Expensive Services (" + BillingMetricFactory_1.BillingCurrency + ")",
            left: [this.costByServiceMetric],
            leftYAxis: common_1.CurrencyAxisUsdFromZero,
            view: aws_cloudwatch_1.GraphWidgetView.BAR,
            // billing is global but resides in single region
            region: BillingMetricFactory_1.BillingRegion,
        });
    }
    createTotalChargesWidget(width, height) {
        return new aws_cloudwatch_1.SingleValueWidget({
            width,
            height,
            title: "Total Cost (" + BillingMetricFactory_1.BillingCurrency + ")",
            metrics: [this.totalCostMetric],
            fullPrecision: false,
            setPeriodToTimeRange: false,
            // billing is global but resides in single region
            region: BillingMetricFactory_1.BillingRegion,
        });
    }
}
exports.BillingMonitoring = BillingMonitoring;
_a = JSII_RTTI_SYMBOL_1;
BillingMonitoring[_a] = { fqn: "cdk-monitoring-constructs.BillingMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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