"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontDistributionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const CloudFrontNamespace = "AWS/CloudFront";
const CloudFrontGlobalRegion = "Global";
const CloudFrontDefaultMetricRegion = "us-east-1";
/**
 * To get the CloudFront metrics from the CloudWatch API, you must use the US East (N. Virginia) Region (us-east-1).
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/programming-cloudwatch-metrics.html
 */
class CloudFrontDistributionMetricFactory {
    constructor(metricFactory, props) {
        var _b, _c;
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = (_b = props.fillTpsWithZeroes) !== null && _b !== void 0 ? _b : true;
        this.rateComputationMethod = (_c = props.rateComputationMethod) !== null && _c !== void 0 ? _c : common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            DistributionId: props.distribution.distributionId,
            Region: CloudFrontGlobalRegion,
        };
    }
    metricRequestCount() {
        return this.metricFactory
            .createMetric("Requests", common_1.MetricStatistic.SUM, "Uploaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricRequestRate() {
        return this.metricFactory.toRate(this.metricRequestCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    /**
     * @deprecated use metricRequestRate
     */
    metricRequestTps() {
        return this.metricFactory.toRate(this.metricRequestCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricTotalBytesUploaded() {
        return this.metricFactory
            .createMetric("BytesUploaded", common_1.MetricStatistic.SUM, "Uploaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricTotalBytesDownloaded() {
        return this.metricFactory
            .createMetric("BytesDownloaded", common_1.MetricStatistic.SUM, "Downloaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricCacheHitRateAverageInPercent() {
        return this.metricFactory
            .createMetric("CacheHitRate", common_1.MetricStatistic.AVERAGE, "Hit Rate", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metric4xxErrorRateAverage() {
        return this.metricFactory
            .createMetric("4xxErrorRate", common_1.MetricStatistic.AVERAGE, "4XX", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metric5xxErrorRateAverage() {
        return this.metricFactory
            .createMetric("5xxErrorRate", common_1.MetricStatistic.AVERAGE, "5XX", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricTotalErrorRateAverage() {
        return this.metricFactory
            .createMetric("TotalErrorRate", common_1.MetricStatistic.AVERAGE, "Total", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
}
exports.CloudFrontDistributionMetricFactory = CloudFrontDistributionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontDistributionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.CloudFrontDistributionMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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