import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { AlarmFactory, BaseMonitoringProps, ErrorAlarmFactory, ErrorRateThreshold, HighTpsThreshold, LowTpsThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, TpsAlarmFactory } from "../../common";
import { MonitoringHeaderWidget, MonitoringNamingStrategy } from "../../dashboard";
import { CloudFrontDistributionMetricFactoryProps } from "./CloudFrontDistributionMetricFactory";
export interface CloudFrontDistributionMonitoringOptions extends BaseMonitoringProps {
}
export interface CloudFrontDistributionMonitoringProps extends CloudFrontDistributionMetricFactoryProps, CloudFrontDistributionMonitoringOptions {
    readonly addLowTpsAlarm?: Record<string, LowTpsThreshold>;
    readonly addHighTpsAlarm?: Record<string, HighTpsThreshold>;
    readonly addError4xxRate?: Record<string, ErrorRateThreshold>;
    readonly addFault5xxRate?: Record<string, ErrorRateThreshold>;
}
export declare class CloudFrontDistributionMonitoring extends Monitoring {
    private readonly title;
    private readonly distributionUrl?;
    protected readonly namingStrategy: MonitoringNamingStrategy;
    protected readonly alarmFactory: AlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly tpsAlarmFactory: TpsAlarmFactory;
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly tpsAnnotations: HorizontalAnnotation[];
    protected readonly tpsMetric: MetricWithAlarmSupport;
    protected readonly downloadedBytesMetric: MetricWithAlarmSupport;
    protected readonly uploadedBytesMetric: MetricWithAlarmSupport;
    protected readonly cacheHitRate: MetricWithAlarmSupport;
    protected readonly error4xxRate: MetricWithAlarmSupport;
    protected readonly error5xxRate: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: CloudFrontDistributionMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createTpsWidget(width: number, height: number): GraphWidget;
    protected createCacheWidget(width: number, height: number): GraphWidget;
    protected createTrafficWidget(width: number, height: number): GraphWidget;
    protected createErrorRateWidget(width: number, height: number): GraphWidget;
}
