import { IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, Monitoring, MonitoringScope } from "../../common";
export interface LogMonitoringProps extends BaseMonitoringProps {
    /**
     * name of the log group to analyze for the given pattern
     */
    readonly logGroupName: string;
    /**
     * pattern to show, e.g. ERROR
     */
    readonly pattern: string;
    /**
     * widget title
     * @default auto-generated title based on the pattern and limit
     */
    readonly title?: string;
    /**
     * number of log messages to search for
     * @default 10
     */
    readonly limit?: number;
}
/**
 * Monitors a CloudWatch log group for various patterns.
 */
export declare class LogMonitoring extends Monitoring {
    protected readonly pattern: string;
    protected readonly logGroupName: string;
    protected readonly logGroupUrl?: string;
    protected readonly title?: string;
    protected readonly limit: number;
    constructor(scope: MonitoringScope, props: LogMonitoringProps);
    widgets(): IWidget[];
    protected resolveRecommendedHeight(numRows: number): number;
}
