"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const DefaultLimit = 10;
/**
 * Monitors a CloudWatch log group for various patterns.
 */
class LogMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope);
        this.pattern = props.pattern;
        this.title = props.title;
        this.limit = (_b = props.limit) !== null && _b !== void 0 ? _b : DefaultLimit;
        this.logGroupName = props.logGroupName;
        this.logGroupUrl = scope
            .createAwsConsoleUrlFactory()
            .getCloudWatchLogGroupUrl(props.logGroupName);
    }
    widgets() {
        var _b;
        return [
            new dashboard_1.MonitoringHeaderWidget({
                family: "Log Group",
                title: this.logGroupName,
                goToLinkUrl: this.logGroupUrl,
            }),
            // Log Query Results
            new aws_cloudwatch_1.LogQueryWidget({
                logGroupNames: [this.logGroupName],
                height: this.resolveRecommendedHeight(this.limit),
                width: common_1.FullWidth,
                title: (_b = this.title) !== null && _b !== void 0 ? _b : `Find ${this.pattern} (limit = ${this.limit})`,
                /**
                 * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html
                 */
                queryLines: [
                    "fields @timestamp, @logStream, @message",
                    `filter @message like /${this.pattern}/`,
                    "sort @timestamp desc",
                    `limit ${this.limit}`,
                ],
            }),
        ];
    }
    resolveRecommendedHeight(numRows) {
        const heightPerLine = 1;
        const recommendedHeight = heightPerLine * numRows;
        return Math.max(recommendedHeight, common_1.DefaultLogWidgetHeight);
    }
}
exports.LogMonitoring = LogMonitoring;
_a = JSII_RTTI_SYMBOL_1;
LogMonitoring[_a] = { fqn: "cdk-monitoring-constructs.LogMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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