"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProjectMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
class CodeBuildProjectMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.project = props.project;
        this.dimensionsMap = {
            ProjectName: props.project.projectName,
        };
    }
    metricBuildCount() {
        return this.metricFactory.adaptMetric(this.project.metricBuilds());
    }
    metricSucceededBuildCount() {
        return this.metricFactory.adaptMetric(this.project.metricSucceededBuilds());
    }
    metricFailedBuildCount() {
        return this.metricFactory.adaptMetric(this.project.metricFailedBuilds());
    }
    metricFailedBuildRate() {
        return this.metricFailedBuildCount().with({
            statistic: common_1.MetricStatistic.AVERAGE,
        });
    }
    metricDurationP99InSeconds() {
        return this.metricFactory.adaptMetric(this.project.metricDuration({
            label: "P99",
            statistic: common_1.MetricStatistic.P99,
        }));
    }
    metricDurationP90InSeconds() {
        return this.metricFactory.adaptMetric(this.project.metricDuration({
            label: "P90",
            statistic: common_1.MetricStatistic.P90,
        }));
    }
    metricDurationP50InSeconds() {
        return this.metricFactory.adaptMetric(this.project.metricDuration({
            label: "P50",
            statistic: common_1.MetricStatistic.P50,
        }));
    }
}
exports.CodeBuildProjectMetricFactory = CodeBuildProjectMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildProjectMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.CodeBuildProjectMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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