import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { IProject } from "aws-cdk-lib/aws-codebuild";
import { BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { CodeBuildProjectMetricFactoryProps } from "./CodeBuildProjectMetricFactory";
export interface CodeBuildProjectMonitoringOptions extends BaseMonitoringProps {
    readonly addDurationP99Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP90Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP50Alarm?: Record<string, DurationThreshold>;
    readonly addFailedBuildCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedBuildRateAlarm?: Record<string, ErrorRateThreshold>;
}
/**
 * Monitoring props for CodeBuild projects.
 */
export interface CodeBuildProjectMonitoringProps extends CodeBuildProjectMetricFactoryProps, CodeBuildProjectMonitoringOptions {
}
export declare class CodeBuildProjectMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly projectUrl?: string;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly durationAlarmFactory: LatencyAlarmFactory;
    protected readonly durationAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly buildCountMetric: MetricWithAlarmSupport;
    protected readonly succeededBuildCountMetric: MetricWithAlarmSupport;
    protected readonly failedBuildCountMetric: MetricWithAlarmSupport;
    protected readonly failedBuildRateMetric: MetricWithAlarmSupport;
    protected readonly durationP99InSecondsMetric: MetricWithAlarmSupport;
    protected readonly durationP90InSecondsMetric: MetricWithAlarmSupport;
    protected readonly durationP50InSecondsMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: CodeBuildProjectMonitoringProps);
    widgets(): IWidget[];
    summaryWidgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createBuildCountsWidget(): GraphWidget;
    protected createDurationWidget(): GraphWidget;
    protected createFailedBuildRateWidget(): GraphWidget;
    protected resolveProjectName(project: IProject): string | undefined;
}
