import { GraphWidget, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { DynamoTableGlobalSecondaryIndexMetricFactoryProps } from "./DynamoTableGlobalSecondaryIndexMetricFactory";
export interface DynamoTableGlobalSecondaryIndexMonitoringProps extends DynamoTableGlobalSecondaryIndexMetricFactoryProps, BaseMonitoringProps {
}
export declare class DynamoTableGlobalSecondaryIndexMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly tableUrl?: string;
    protected readonly provisionedReadUnitsMetric: MetricWithAlarmSupport;
    protected readonly provisionedWriteUnitsMetric: MetricWithAlarmSupport;
    protected readonly consumedReadUnitsMetric: MetricWithAlarmSupport;
    protected readonly consumedWriteUnitsMetric: MetricWithAlarmSupport;
    protected readonly indexConsumedWriteUnitsMetric: MetricWithAlarmSupport;
    protected readonly readThrottleCountMetric: MetricWithAlarmSupport;
    protected readonly writeThrottleCountMetric: MetricWithAlarmSupport;
    protected readonly indexThrottleCountMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: DynamoTableGlobalSecondaryIndexMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createReadCapacityWidget(width: number, height: number): GraphWidget;
    protected createWriteCapacityWidget(width: number, height: number): GraphWidget;
    protected createThrottlesWidget(width: number, height: number): GraphWidget;
}
