import { GraphWidget, HorizontalAnnotation, IMetric, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { Operation } from "aws-cdk-lib/aws-dynamodb";
import { AlarmFactory, BaseMonitoringProps, ConsumedCapacityThreshold, DynamoAlarmFactory, ErrorAlarmFactory, ErrorCountThreshold, LatencyAlarmFactory, LatencyThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, ThrottledEventsThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { DynamoTableMetricFactoryProps } from "./DynamoTableMetricFactory";
export interface DynamoTableMonitoringOptions extends BaseMonitoringProps {
    readonly addConsumedReadCapacityAlarm?: Record<string, ConsumedCapacityThreshold>;
    readonly addConsumedWriteCapacityAlarm?: Record<string, ConsumedCapacityThreshold>;
    readonly addReadThrottledEventsCountAlarm?: Record<string, ThrottledEventsThreshold>;
    readonly addWriteThrottledEventsCountAlarm?: Record<string, ThrottledEventsThreshold>;
    readonly addSystemErrorCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addAverageSuccessfulGetRecordsLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulQueryLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulScanLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulPutItemLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulGetItemLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulUpdateItemLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulDeleteItemLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulBatchGetItemLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly addAverageSuccessfulBatchWriteItemLatencyAlarm?: Record<string, LatencyThreshold>;
}
export interface DynamoTableMonitoringProps extends DynamoTableMetricFactoryProps, DynamoTableMonitoringOptions {
}
export declare class DynamoTableMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly tableUrl?: string;
    protected readonly alarmFactory: AlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly latencyAlarmFactory: LatencyAlarmFactory;
    protected readonly dynamoCapacityAlarmFactory: DynamoAlarmFactory;
    protected readonly latencyAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly dynamoReadCapacityAnnotations: HorizontalAnnotation[];
    protected readonly dynamoWriteCapacityAnnotations: HorizontalAnnotation[];
    protected readonly throttledEventsAnnotations: HorizontalAnnotation[];
    protected readonly provisionedReadUnitsMetric: MetricWithAlarmSupport;
    protected readonly provisionedWriteUnitsMetric: MetricWithAlarmSupport;
    protected readonly consumedReadUnitsMetric: MetricWithAlarmSupport;
    protected readonly consumedWriteUnitsMetric: MetricWithAlarmSupport;
    protected readonly readThrottleCountMetric: MetricWithAlarmSupport;
    protected readonly writeThrottleCountMetric: MetricWithAlarmSupport;
    protected readonly systemErrorMetric: MetricWithAlarmSupport;
    protected readonly latencyAverageSearchMetrics: IMetric;
    protected readonly averagePerOperationLatencyMetrics: Record<string, MetricWithAlarmSupport>;
    protected readonly readCapacityUsageMetric: MetricWithAlarmSupport;
    protected readonly writeCapacityUsageMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: DynamoTableMonitoringProps);
    protected forEachOperationLatencyAlarmDefinition(operation: Operation, alarm?: Record<string, LatencyThreshold>): void;
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createThrottlesWidget(width: number, height: number): GraphWidget;
    protected createErrorsWidget(width: number, height: number): GraphWidget;
    protected createReadCapacityWidget(width: number, height: number): GraphWidget;
    protected createWriteCapacityWidget(width: number, height: number): GraphWidget;
    protected createTitleWidget(): MonitoringHeaderWidget;
    private resolveTableName;
}
