"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoTableMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_dynamodb_1 = require("aws-cdk-lib/aws-dynamodb");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const DynamoTableMetricFactory_1 = require("./DynamoTableMetricFactory");
class DynamoTableMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.table,
            fallbackConstructName: this.resolveTableName(props.table),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.tableUrl = scope
            .createAwsConsoleUrlFactory()
            .getDynamoTableUrl(props.table.tableName);
        this.alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(this.alarmFactory);
        this.latencyAlarmFactory = new common_1.LatencyAlarmFactory(this.alarmFactory);
        this.dynamoCapacityAlarmFactory = new common_1.DynamoAlarmFactory(this.alarmFactory);
        this.errorCountAnnotations = [];
        this.latencyAnnotations = [];
        this.dynamoReadCapacityAnnotations = [];
        this.dynamoWriteCapacityAnnotations = [];
        this.throttledEventsAnnotations = [];
        const metricFactory = new DynamoTableMetricFactory_1.DynamoTableMetricFactory(scope.createMetricFactory(), props);
        this.provisionedReadUnitsMetric =
            metricFactory.metricProvisionedReadCapacityUnits();
        this.provisionedWriteUnitsMetric =
            metricFactory.metricProvisionedWriteCapacityUnits();
        this.consumedReadUnitsMetric =
            metricFactory.metricConsumedReadCapacityUnits();
        this.consumedWriteUnitsMetric =
            metricFactory.metricConsumedWriteCapacityUnits();
        this.readThrottleCountMetric =
            metricFactory.metricThrottledReadRequestCount();
        this.writeThrottleCountMetric =
            metricFactory.metricThrottledWriteRequestCount();
        this.systemErrorMetric = metricFactory.metricSystemErrorsCount();
        this.latencyAverageSearchMetrics =
            metricFactory.metricSearchAverageSuccessfulRequestLatencyInMillis();
        this.averagePerOperationLatencyMetrics = {
            [aws_dynamodb_1.Operation.GET_RECORDS]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.GET_RECORDS),
            [aws_dynamodb_1.Operation.QUERY]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.QUERY),
            [aws_dynamodb_1.Operation.SCAN]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.SCAN),
            [aws_dynamodb_1.Operation.PUT_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.PUT_ITEM),
            [aws_dynamodb_1.Operation.GET_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.GET_ITEM),
            [aws_dynamodb_1.Operation.UPDATE_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.UPDATE_ITEM),
            [aws_dynamodb_1.Operation.DELETE_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.DELETE_ITEM),
            [aws_dynamodb_1.Operation.BATCH_GET_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.BATCH_GET_ITEM),
            [aws_dynamodb_1.Operation.BATCH_WRITE_ITEM]: metricFactory.metricAverageSuccessfulRequestLatencyInMillis(aws_dynamodb_1.Operation.BATCH_WRITE_ITEM),
        };
        this.readCapacityUsageMetric =
            metricFactory.metricReadCapacityUtilizationPercentage();
        this.writeCapacityUsageMetric =
            metricFactory.metricWriteCapacityUtilizationPercentage();
        for (const disambiguator in props.addConsumedReadCapacityAlarm) {
            const alarmProps = props.addConsumedReadCapacityAlarm[disambiguator];
            const createdAlarm = this.dynamoCapacityAlarmFactory.addConsumedCapacityAlarm(this.consumedReadUnitsMetric, common_1.CapacityType.READ, alarmProps, disambiguator);
            this.dynamoReadCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addConsumedWriteCapacityAlarm) {
            const alarmProps = props.addConsumedWriteCapacityAlarm[disambiguator];
            const createdAlarm = this.dynamoCapacityAlarmFactory.addConsumedCapacityAlarm(this.consumedWriteUnitsMetric, common_1.CapacityType.WRITE, alarmProps, disambiguator);
            this.dynamoWriteCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addReadThrottledEventsCountAlarm) {
            const alarmProps = props.addReadThrottledEventsCountAlarm[disambiguator];
            const createdAlarm = this.dynamoCapacityAlarmFactory.addThrottledEventsAlarm(this.readThrottleCountMetric, common_1.CapacityType.READ, alarmProps, disambiguator);
            this.throttledEventsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addWriteThrottledEventsCountAlarm) {
            const alarmProps = props.addWriteThrottledEventsCountAlarm[disambiguator];
            const createdAlarm = this.dynamoCapacityAlarmFactory.addThrottledEventsAlarm(this.writeThrottleCountMetric, common_1.CapacityType.WRITE, alarmProps, disambiguator);
            this.throttledEventsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addSystemErrorCountAlarm) {
            const alarmProps = props.addSystemErrorCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.systemErrorMetric, common_1.ErrorType.SYSTEM_ERROR, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.GET_RECORDS, props.addAverageSuccessfulGetRecordsLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.QUERY, props.addAverageSuccessfulQueryLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.SCAN, props.addAverageSuccessfulScanLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.PUT_ITEM, props.addAverageSuccessfulPutItemLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.GET_ITEM, props.addAverageSuccessfulGetItemLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.UPDATE_ITEM, props.addAverageSuccessfulUpdateItemLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.DELETE_ITEM, props.addAverageSuccessfulDeleteItemLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.BATCH_GET_ITEM, props.addAverageSuccessfulBatchGetItemLatencyAlarm);
        this.forEachOperationLatencyAlarmDefinition(aws_dynamodb_1.Operation.BATCH_WRITE_ITEM, props.addAverageSuccessfulBatchWriteItemLatencyAlarm);
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    forEachOperationLatencyAlarmDefinition(operation, alarm) {
        for (const disambiguator in alarm) {
            const alarmProps = alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            this.averagePerOperationLatencyMetrics[operation], common_1.LatencyType.AVERAGE, alarmProps, operation + "-" + disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
    }
    summaryWidgets() {
        return [
            // Title
            this.createTitleWidget(),
            // Read units
            this.createReadCapacityWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            // Write units
            this.createWriteCapacityWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            // Title
            this.createTitleWidget(),
            new aws_cloudwatch_1.Column(
            // Read units
            this.createReadCapacityWidget(common_1.QuarterWidth, common_1.DefaultTwoLinerGraphWidgetHalfHeight), 
            // Write units
            this.createWriteCapacityWidget(common_1.QuarterWidth, common_1.DefaultTwoLinerGraphWidgetHalfHeight)),
            // Latency
            this.createLatencyWidget(common_1.QuarterWidth + common_1.HalfQuarterWidth, common_1.DefaultTwoLinerGraphWidgetHeight),
            // Throttles
            this.createThrottlesWidget(common_1.HalfQuarterWidth, common_1.DefaultTwoLinerGraphWidgetHeight),
            // Errors
            this.createErrorsWidget(common_1.QuarterWidth, common_1.DefaultTwoLinerGraphWidgetHeight),
        ];
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency (Average)",
            left: [this.latencyAverageSearchMetrics],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.latencyAnnotations,
            legendPosition: aws_cloudwatch_1.LegendPosition.RIGHT,
        });
    }
    createThrottlesWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Throttles",
            left: [this.readThrottleCountMetric, this.writeThrottleCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.throttledEventsAnnotations,
        });
    }
    createErrorsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors",
            left: [this.systemErrorMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.errorCountAnnotations,
        });
    }
    createReadCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Read Usage",
            left: [this.consumedReadUnitsMetric, this.provisionedReadUnitsMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.dynamoReadCapacityAnnotations,
            right: [this.readCapacityUsageMetric],
            rightYAxis: common_1.PercentageAxisFromZeroToHundred,
            legendPosition: aws_cloudwatch_1.LegendPosition.RIGHT,
        });
    }
    createWriteCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Write Usage",
            left: [this.consumedWriteUnitsMetric, this.provisionedWriteUnitsMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.dynamoWriteCapacityAnnotations,
            right: [this.writeCapacityUsageMetric],
            rightYAxis: common_1.PercentageAxisFromZeroToHundred,
            legendPosition: aws_cloudwatch_1.LegendPosition.RIGHT,
        });
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Dynamo Table",
            title: this.title,
            goToLinkUrl: this.tableUrl,
        });
    }
    resolveTableName(dynamoTable) {
        var _b;
        // try to take the name (if specified) instead of token
        return (_b = dynamoTable.node.defaultChild) === null || _b === void 0 ? void 0 : _b.tableName;
    }
}
exports.DynamoTableMonitoring = DynamoTableMonitoring;
_a = JSII_RTTI_SYMBOL_1;
DynamoTableMonitoring[_a] = { fqn: "cdk-monitoring-constructs.DynamoTableMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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