import { GraphWidget, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { AutoScalingGroupMetricFactoryProps } from "./AutoScalingGroupMetricFactory";
export interface AutoScalingGroupMonitoringOptions extends BaseMonitoringProps {
}
export interface AutoScalingGroupMonitoringProps extends AutoScalingGroupMetricFactoryProps, AutoScalingGroupMonitoringOptions {
}
export declare class AutoScalingGroupMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly groupMinSizeMetric: MetricWithAlarmSupport;
    protected readonly groupMaxSizeMetric: MetricWithAlarmSupport;
    protected readonly groupDesiredSizeMetric: MetricWithAlarmSupport;
    protected readonly instancesInServiceMetric: MetricWithAlarmSupport;
    protected readonly instancesPendingMetric: MetricWithAlarmSupport;
    protected readonly instancesStandbyMetric: MetricWithAlarmSupport;
    protected readonly instancesTerminatingMetric: MetricWithAlarmSupport;
    protected readonly instancesTotalMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: AutoScalingGroupMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createGroupSizeWidget(width: number, height: number): GraphWidget;
    protected createGroupStatusWidget(width: number, height: number): GraphWidget;
}
