"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingGroupMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const AutoScalingGroupMetricFactory_1 = require("./AutoScalingGroupMetricFactory");
class AutoScalingGroupMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const fallbackConstructName = props.autoScalingGroup.autoScalingGroupName;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.autoScalingGroup,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        const metricFactory = new AutoScalingGroupMetricFactory_1.AutoScalingGroupMetricFactory(scope.createMetricFactory(), props);
        this.groupMinSizeMetric = metricFactory.metricGroupMinSize();
        this.groupMaxSizeMetric = metricFactory.metricGroupMaxSize();
        this.groupDesiredSizeMetric = metricFactory.metricGroupDesiredCapacity();
        this.instancesInServiceMetric =
            metricFactory.metricGroupInServiceInstances();
        this.instancesPendingMetric = metricFactory.metricGroupPendingInstances();
        this.instancesStandbyMetric = metricFactory.metricGroupStandbyInstances();
        this.instancesTerminatingMetric =
            metricFactory.metricGroupTerminatingInstances();
        this.instancesTotalMetric = metricFactory.metricGroupTotalInstances();
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createGroupSizeWidget(common_1.FullWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createGroupSizeWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
            this.createGroupStatusWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Auto Scaling Group",
            title: this.title,
        });
    }
    createGroupSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Group Size",
            left: [
                this.groupMinSizeMetric,
                this.groupMaxSizeMetric,
                this.groupDesiredSizeMetric,
                this.instancesTotalMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createGroupStatusWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Instance States",
            left: [
                this.instancesInServiceMetric,
                this.instancesPendingMetric,
                this.instancesStandbyMetric,
                this.instancesTerminatingMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            stacked: true,
        });
    }
}
exports.AutoScalingGroupMonitoring = AutoScalingGroupMonitoring;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingGroupMonitoring[_a] = { fqn: "cdk-monitoring-constructs.AutoScalingGroupMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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