import { GraphWidget, IMetric, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { EC2MetricFactoryProps } from "./EC2MetricFactory";
export interface EC2MonitoringOptions extends EC2MetricFactoryProps, BaseMonitoringProps {
}
export interface EC2MonitoringProps extends EC2MonitoringOptions {
}
export declare class EC2Monitoring extends Monitoring {
    protected readonly family: string;
    protected readonly title: string;
    protected readonly cpuUtilisationMetrics: IMetric[];
    protected readonly diskReadBytesMetrics: IMetric[];
    protected readonly diskWriteBytesMetrics: IMetric[];
    protected readonly diskReadOpsMetrics: IMetric[];
    protected readonly diskWriteOpsMetrics: IMetric[];
    protected readonly networkInMetrics: IMetric[];
    protected readonly networkOutMetrics: IMetric[];
    constructor(scope: MonitoringScope, props: EC2MonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuWidget(width: number, height: number): GraphWidget;
    protected createDiskWidget(width: number, height: number): GraphWidget;
    protected createDiskOpsWidget(width: number, height: number): GraphWidget;
    protected createNetworkWidget(width: number, height: number): GraphWidget;
}
