"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EC2Monitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const EC2MetricFactory_1 = require("./EC2MetricFactory");
class EC2Monitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const fallbackConstructName = props.autoScalingGroup
            ? props.autoScalingGroup.autoScalingGroupName
            : "All Instances";
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.family = props.autoScalingGroup ? "EC2 Auto Scaling Group" : "EC2";
        this.title = namingStrategy.resolveHumanReadableName();
        const metricFactory = new EC2MetricFactory_1.EC2MetricFactory(scope.createMetricFactory(), props);
        this.cpuUtilisationMetrics =
            metricFactory.metricAverageCpuUtilisationPercent();
        this.diskReadBytesMetrics = metricFactory.metricAverageDiskReadBytes();
        this.diskWriteBytesMetrics = metricFactory.metricAverageDiskWriteBytes();
        this.diskReadOpsMetrics = metricFactory.metricAverageDiskReadOps();
        this.diskWriteOpsMetrics = metricFactory.metricAverageDiskWriteOps();
        this.networkInMetrics = metricFactory.metricAverageNetworkInRateBytes();
        this.networkOutMetrics = metricFactory.metricAverageNetworkOutRateBytes();
    }
    summaryWidgets() {
        return [
            // Title
            this.createTitleWidget(),
            // CPU Usage
            this.createCpuWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            // Disk OPS
            this.createDiskOpsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            // Network
            this.createNetworkWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            // Title
            this.createTitleWidget(),
            // CPU Usage
            this.createCpuWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            // Disk OPS
            this.createDiskOpsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            // Disk Bytes
            this.createDiskWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            // Network
            this.createNetworkWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: this.family,
            title: this.title,
        });
    }
    createCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [...this.cpuUtilisationMetrics],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
        });
    }
    createDiskWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Disk - Bytes",
            left: [...this.diskReadBytesMetrics, ...this.diskWriteBytesMetrics],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createDiskOpsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Disk - OPS",
            left: [...this.diskReadOpsMetrics, ...this.diskWriteOpsMetrics],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createNetworkWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Network",
            left: [...this.networkInMetrics, ...this.networkOutMetrics],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.EC2Monitoring = EC2Monitoring;
_a = JSII_RTTI_SYMBOL_1;
EC2Monitoring[_a] = { fqn: "cdk-monitoring-constructs.EC2Monitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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