import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { Ec2Service } from "aws-cdk-lib/aws-ecs";
import { ApplicationLoadBalancedEc2Service, NetworkLoadBalancedEc2Service } from "aws-cdk-lib/aws-ecs-patterns";
import { ApplicationLoadBalancer, ApplicationTargetGroup, NetworkLoadBalancer, NetworkTargetGroup } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { BaseMonitoringProps, HealthyTaskCountThreshold, HealthyTaskPercentThreshold, MetricFactory, MetricWithAlarmSupport, MinProcessedBytesThreshold, Monitoring, MonitoringScope, RunningTaskCountThreshold, TaskHealthAlarmFactory, ThroughputAlarmFactory, UnhealthyTaskCountThreshold, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { ApplicationLoadBalancerMetricFactoryProps, ILoadBalancerMetricFactory, NetworkLoadBalancerMetricFactoryProps } from "../aws-loadbalancing";
import { BaseServiceMetricFactory } from "./BaseServiceMetricFactory";
export interface BaseEc2ServiceAlarms {
    /**
     * minimum number of tasks, as specified in your auto scaling config
     */
    readonly minAutoScalingTaskCount?: number;
    /**
     * maximum number of tasks, as specified in your auto scaling config
     */
    readonly maxAutoScalingTaskCount?: number;
    /**
     * Container Insights needs to be enabled for the cluster for this alarm
     */
    readonly addRunningTaskCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
    readonly addMemoryUsageAlarm?: Record<string, UsageThreshold>;
}
/**
 * Monitoring props for any type of EC2 service.
 */
interface BaseEc2ServiceMonitoringProps extends BaseMonitoringProps, BaseEc2ServiceAlarms {
}
/**
 * Monitoring props for Simple EC2 service.
 */
export interface SimpleEc2ServiceMonitoringProps extends BaseEc2ServiceMonitoringProps {
    readonly ec2Service: Ec2Service;
}
/**
 * Base of Monitoring props for load-balanced EC2 service.
 */
interface BaseLoadBalancedEc2ServiceMonitoringProps extends BaseEc2ServiceMonitoringProps {
    readonly addHealthyTaskCountAlarm?: Record<string, HealthyTaskCountThreshold>;
    readonly addUnhealthyTaskCountAlarm?: Record<string, UnhealthyTaskCountThreshold>;
    readonly addHealthyTaskPercentAlarm?: Record<string, HealthyTaskPercentThreshold>;
    readonly addMinProcessedBytesAlarm?: Record<string, MinProcessedBytesThreshold>;
}
/**
 * Monitoring props for load-balanced EC2 service.
 */
export interface Ec2ServiceMonitoringProps extends BaseLoadBalancedEc2ServiceMonitoringProps {
    readonly ec2Service: NetworkLoadBalancedEc2Service | ApplicationLoadBalancedEc2Service;
}
/**
 * Monitoring props for EC2 service with network load balancer and plain service.
 */
export interface Ec2NetworkLoadBalancerMonitoringProps extends NetworkLoadBalancerMetricFactoryProps, BaseLoadBalancedEc2ServiceMonitoringProps {
    readonly ec2Service: Ec2Service;
}
/**
 * Monitoring props for EC2 service with application load balancer and plain service.
 */
export interface Ec2ApplicationLoadBalancerMonitoringProps extends ApplicationLoadBalancerMetricFactoryProps, BaseLoadBalancedEc2ServiceMonitoringProps {
    readonly ec2Service: Ec2Service;
}
export interface CustomEc2ServiceMonitoringProps extends BaseLoadBalancedEc2ServiceMonitoringProps {
    readonly ec2Service: Ec2Service;
    readonly loadBalancer?: ApplicationLoadBalancer | NetworkLoadBalancer;
    readonly targetGroup?: ApplicationTargetGroup | NetworkTargetGroup;
}
export declare class Ec2ServiceMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly metricFactory: MetricFactory;
    protected readonly baseServiceMetricFactory: BaseServiceMetricFactory;
    protected readonly loadBalancerMetricFactory?: ILoadBalancerMetricFactory;
    protected readonly taskHealthAlarmFactory: TaskHealthAlarmFactory;
    protected readonly throughputAlarmFactory: ThroughputAlarmFactory;
    protected readonly taskHealthAnnotations: HorizontalAnnotation[];
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly cpuUsageAnnotations: HorizontalAnnotation[];
    protected readonly memoryUsageAnnotations: HorizontalAnnotation[];
    protected readonly processedBytesAnnotations: HorizontalAnnotation[];
    protected readonly healthyTaskCountMetric?: MetricWithAlarmSupport;
    protected readonly unhealthyTaskCountMetric?: MetricWithAlarmSupport;
    protected readonly healthyTaskPercentMetric?: MetricWithAlarmSupport;
    protected readonly runningTaskCountMetric: MetricWithAlarmSupport;
    protected readonly cpuUtilisationMetric: MetricWithAlarmSupport;
    protected readonly memoryUtilisationMetric: MetricWithAlarmSupport;
    protected readonly activeTcpFlowCountMetric?: MetricWithAlarmSupport;
    protected readonly newTcpFlowCountMetric?: MetricWithAlarmSupport;
    protected readonly processedBytesMetric?: MetricWithAlarmSupport;
    private hasLoadBalancer;
    constructor(scope: MonitoringScope, props: CustomEc2ServiceMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuWidget(width: number, height: number): GraphWidget;
    protected createMemoryWidget(width: number, height: number): GraphWidget;
    protected createTaskHealthWidget(width: number, height: number): GraphWidget;
    protected createTpcFlowsWidget(width: number, height: number): GraphWidget;
}
export {};
