"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2ServiceMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const aws_loadbalancing_1 = require("../aws-loadbalancing");
const BaseServiceMetricFactory_1 = require("./BaseServiceMetricFactory");
class Ec2ServiceMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        this.hasLoadBalancer =
            props.loadBalancer !== undefined && props.targetGroup !== undefined;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.ec2Service,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.metricFactory = scope.createMetricFactory();
        this.baseServiceMetricFactory = new BaseServiceMetricFactory_1.BaseServiceMetricFactory(this.metricFactory, { service: props.ec2Service });
        if (this.hasLoadBalancer) {
            this.loadBalancerMetricFactory = aws_loadbalancing_1.createLoadBalancerMetricFactory(this.metricFactory, props.loadBalancer, props.targetGroup);
            this.healthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskCount();
            this.unhealthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricUnhealthyTaskCount();
            this.healthyTaskPercentMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskInPercent();
            this.activeTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricActiveConnectionCount();
            this.newTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricNewConnectionCount();
            this.processedBytesMetric =
                this.loadBalancerMetricFactory.metricProcessedBytesMin();
        }
        this.runningTaskCountMetric =
            this.baseServiceMetricFactory.metricRunningTaskCount();
        this.cpuUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterCpuUtilisationInPercent();
        this.memoryUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterMemoryUtilisationInPercent();
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(alarmFactory);
        this.throughputAlarmFactory = new common_1.ThroughputAlarmFactory(alarmFactory);
        this.taskHealthAnnotations = [];
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.cpuUsageAnnotations = [];
        this.memoryUsageAnnotations = [];
        this.processedBytesAnnotations = [];
        if (props.minAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.minAutoScalingTaskCount,
                label: "AutoScaling: Min",
                color: common_1.NeutralColor,
            });
        }
        if (props.maxAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.maxAutoScalingTaskCount,
                label: "AutoScaling: Max",
                color: common_1.NeutralColor,
            });
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addHealthyTaskCountAlarm) {
                const alarmProps = props.addHealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addUnhealthyTaskCountAlarm) {
                const alarmProps = props.addUnhealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addUnhealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.unhealthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addHealthyTaskPercentAlarm) {
                const alarmProps = props.addHealthyTaskPercentAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskPercentAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskPercentMetric, alarmProps, disambiguator);
                this.addAlarm(createdAlarm);
            }
        }
        for (const disambiguator in props.addRunningTaskCountAlarm) {
            const alarmProps = props.addRunningTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.runningTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUtilisationMetric, alarmProps, disambiguator);
            this.cpuUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMemoryUsageAlarm) {
            const alarmProps = props.addMemoryUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(this.memoryUtilisationMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addMinProcessedBytesAlarm) {
                const alarmProps = props.addMinProcessedBytesAlarm[disambiguator];
                const createdAlarm = this.throughputAlarmFactory.addMinProcessedBytesAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.processedBytesMetric, alarmProps, disambiguator);
                this.processedBytesAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMemoryWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        const baseWidget = [
            this.createTitleWidget(),
            this.createCpuWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMemoryWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
        if (this.hasLoadBalancer) {
            return baseWidget.concat([
                this.createTpcFlowsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createTaskHealthWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            ]);
        }
        else {
            return baseWidget.concat(this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight));
        }
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Ec2 Service",
            title: this.title,
        });
    }
    createCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [this.cpuUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.cpuUsageAnnotations,
        });
    }
    createMemoryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [this.memoryUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.memoryUsageAnnotations,
        });
    }
    createTaskHealthWidget(width, height) {
        const left = [this.runningTaskCountMetric];
        if (this.healthyTaskCountMetric) {
            left.push(this.healthyTaskCountMetric);
        }
        if (this.unhealthyTaskCountMetric) {
            left.push(this.unhealthyTaskCountMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: this.hasLoadBalancer ? "Task Health" : "Task Count",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.taskHealthAnnotations,
        });
    }
    createTpcFlowsWidget(width, height) {
        const left = [];
        const right = [];
        if (this.activeTcpFlowCountMetric) {
            left.push(this.activeTcpFlowCountMetric);
        }
        if (this.newTcpFlowCountMetric) {
            left.push(this.newTcpFlowCountMetric);
        }
        if (this.processedBytesMetric) {
            right.push(this.processedBytesMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TCP Flows",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            right,
            rightYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.Ec2ServiceMonitoring = Ec2ServiceMonitoring;
_a = JSII_RTTI_SYMBOL_1;
Ec2ServiceMonitoring[_a] = { fqn: "cdk-monitoring-constructs.Ec2ServiceMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRWMyU2VydmljZU1vbml0b3JpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJFYzJTZXJ2aWNlTW9uaXRvcmluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtEQUtvQztBQWFwQyx5Q0F1QnNCO0FBQ3RCLCtDQUd5QjtBQUN6Qiw0REFLOEI7QUFDOUIseUVBQXNFO0FBeUZ0RSxNQUFhLG9CQUFxQixTQUFRLG1CQUFVO0lBMkJsRCxZQUFZLEtBQXNCLEVBQUUsS0FBc0M7O1FBQ3hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFcEIsSUFBSSxDQUFDLGVBQWU7WUFDbEIsS0FBSyxDQUFDLFlBQVksS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFdBQVcsS0FBSyxTQUFTLENBQUM7UUFFdEUsTUFBTSxjQUFjLEdBQUcsSUFBSSxvQ0FBd0IsQ0FBQztZQUNsRCxHQUFHLEtBQUs7WUFDUixjQUFjLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDakMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztRQUV2RCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO1FBQ2pELElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLG1EQUF3QixDQUMxRCxJQUFJLENBQUMsYUFBYSxFQUNsQixFQUFFLE9BQU8sRUFBRSxLQUFLLENBQUMsVUFBVSxFQUFFLENBQzlCLENBQUM7UUFDRixJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDeEIsSUFBSSxDQUFDLHlCQUF5QixHQUFHLG1EQUErQixDQUM5RCxJQUFJLENBQUMsYUFBYSxFQUNsQixLQUFLLENBQUMsWUFBWSxFQUNsQixLQUFLLENBQUMsV0FBVyxDQUNsQixDQUFDO1lBQ0YsSUFBSSxDQUFDLHNCQUFzQjtnQkFDekIsSUFBSSxDQUFDLHlCQUF5QixDQUFDLHNCQUFzQixFQUFFLENBQUM7WUFDMUQsSUFBSSxDQUFDLHdCQUF3QjtnQkFDM0IsSUFBSSxDQUFDLHlCQUF5QixDQUFDLHdCQUF3QixFQUFFLENBQUM7WUFDNUQsSUFBSSxDQUFDLHdCQUF3QjtnQkFDM0IsSUFBSSxDQUFDLHlCQUF5QixDQUFDLDBCQUEwQixFQUFFLENBQUM7WUFDOUQsSUFBSSxDQUFDLHdCQUF3QjtnQkFDM0IsSUFBSSxDQUFDLHlCQUF5QixDQUFDLDJCQUEyQixFQUFFLENBQUM7WUFDL0QsSUFBSSxDQUFDLHFCQUFxQjtnQkFDeEIsSUFBSSxDQUFDLHlCQUF5QixDQUFDLHdCQUF3QixFQUFFLENBQUM7WUFDNUQsSUFBSSxDQUFDLG9CQUFvQjtnQkFDdkIsSUFBSSxDQUFDLHlCQUF5QixDQUFDLHVCQUF1QixFQUFFLENBQUM7U0FDNUQ7UUFDRCxJQUFJLENBQUMsc0JBQXNCO1lBQ3pCLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1FBQ3pELElBQUksQ0FBQyxvQkFBb0I7WUFDdkIsSUFBSSxDQUFDLHdCQUF3QixDQUFDLG9DQUFvQyxFQUFFLENBQUM7UUFDdkUsSUFBSSxDQUFDLHVCQUF1QjtZQUMxQixJQUFJLENBQUMsd0JBQXdCLENBQUMsdUNBQXVDLEVBQUUsQ0FBQztRQUUxRSxNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQzFDLGNBQWMsQ0FBQyx3QkFBd0IsRUFBRSxDQUMxQyxDQUFDO1FBQ0YsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksK0JBQXNCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksK0JBQXNCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEVBQUUsQ0FBQztRQUNoQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSwwQkFBaUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUM3RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO1FBQzlCLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxFQUFFLENBQUM7UUFDakMsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEVBQUUsQ0FBQztRQUVwQyxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsRUFBRTtZQUNqQyw2REFBNkQ7WUFDN0QsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQztnQkFDOUIsS0FBSyxFQUFFLEtBQUssQ0FBQyx1QkFBdUI7Z0JBQ3BDLEtBQUssRUFBRSxrQkFBa0I7Z0JBQ3pCLEtBQUssRUFBRSxxQkFBWTthQUNwQixDQUFDLENBQUM7U0FDSjtRQUNELElBQUksS0FBSyxDQUFDLHVCQUF1QixFQUFFO1lBQ2pDLDZEQUE2RDtZQUM3RCxJQUFJLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDO2dCQUM5QixLQUFLLEVBQUUsS0FBSyxDQUFDLHVCQUF1QjtnQkFDcEMsS0FBSyxFQUFFLGtCQUFrQjtnQkFDekIsS0FBSyxFQUFFLHFCQUFZO2FBQ3BCLENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFO1lBQ3hCLEtBQUssTUFBTSxhQUFhLElBQUksS0FBSyxDQUFDLHdCQUF3QixFQUFFO2dCQUMxRCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsd0JBQXdCLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ2pFLE1BQU0sWUFBWSxHQUNoQixJQUFJLENBQUMsc0JBQXNCLENBQUMsd0JBQXdCO2dCQUNsRCxvRUFBb0U7Z0JBQ3BFLElBQUksQ0FBQyxzQkFBdUIsRUFDNUIsVUFBVSxFQUNWLGFBQWEsQ0FDZCxDQUFDO2dCQUNKLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO2FBQzdCO1lBQ0QsS0FBSyxNQUFNLGFBQWEsSUFBSSxLQUFLLENBQUMsMEJBQTBCLEVBQUU7Z0JBQzVELE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQywwQkFBMEIsQ0FBQyxhQUFhLENBQUMsQ0FBQztnQkFDbkUsTUFBTSxZQUFZLEdBQ2hCLElBQUksQ0FBQyxzQkFBc0IsQ0FBQywwQkFBMEI7Z0JBQ3BELG9FQUFvRTtnQkFDcEUsSUFBSSxDQUFDLHdCQUF5QixFQUM5QixVQUFVLEVBQ1YsYUFBYSxDQUNkLENBQUM7Z0JBQ0osSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7YUFDN0I7WUFDRCxLQUFLLE1BQU0sYUFBYSxJQUFJLEtBQUssQ0FBQywwQkFBMEIsRUFBRTtnQkFDNUQsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUNuRSxNQUFNLFlBQVksR0FDaEIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLDBCQUEwQjtnQkFDcEQsb0VBQW9FO2dCQUNwRSxJQUFJLENBQUMsd0JBQXlCLEVBQzlCLFVBQVUsRUFDVixhQUFhLENBQ2QsQ0FBQztnQkFDSixJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO2FBQzdCO1NBQ0Y7UUFFRCxLQUFLLE1BQU0sYUFBYSxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsRUFBRTtZQUMxRCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsd0JBQXdCLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDakUsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDLHdCQUF3QixDQUN2RSxJQUFJLENBQUMsc0JBQXNCLEVBQzNCLFVBQVUsRUFDVixhQUFhLENBQ2QsQ0FBQztZQUNGLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ3pELElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDN0I7UUFDRCxLQUFLLE1BQU0sYUFBYSxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRTtZQUNsRCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDekQsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixDQUNwRSxJQUFJLENBQUMsb0JBQW9CLEVBQ3pCLFVBQVUsRUFDVixhQUFhLENBQ2QsQ0FBQztZQUNGLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ3ZELElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDN0I7UUFDRCxLQUFLLE1BQU0sYUFBYSxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsRUFBRTtZQUNyRCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDNUQsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixDQUN2RSxJQUFJLENBQUMsdUJBQXVCLEVBQzVCLFVBQVUsRUFDVixhQUFhLENBQ2QsQ0FBQztZQUNGLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQzFELElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDN0I7UUFFRCxJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDeEIsS0FBSyxNQUFNLGFBQWEsSUFBSSxLQUFLLENBQUMseUJBQXlCLEVBQUU7Z0JBQzNELE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztnQkFDbEUsTUFBTSxZQUFZLEdBQ2hCLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyx5QkFBeUI7Z0JBQ25ELG9FQUFvRTtnQkFDcEUsSUFBSSxDQUFDLG9CQUFxQixFQUMxQixVQUFVLEVBQ1YsYUFBYSxDQUNkLENBQUM7Z0JBQ0osSUFBSSxDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7Z0JBQzdELElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7YUFDN0I7U0FDRjtRQUVELE1BQUEsS0FBSyxDQUFDLGdCQUFnQiwwQ0FBRSxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxFQUFFO0lBQ3hELENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTztZQUNMLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLG1CQUFVLEVBQUUsbUNBQTBCLENBQUM7WUFDNUQsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFVLEVBQUUsbUNBQTBCLENBQUM7WUFDL0QsSUFBSSxDQUFDLHNCQUFzQixDQUFDLG1CQUFVLEVBQUUsbUNBQTBCLENBQUM7U0FDcEUsQ0FBQztJQUNKLENBQUM7SUFFRCxPQUFPO1FBQ0wsTUFBTSxVQUFVLEdBQUc7WUFDakIsSUFBSSxDQUFDLGlCQUFpQixFQUFFO1lBQ3hCLElBQUksQ0FBQyxlQUFlLENBQ2xCLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLHFCQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFVLEVBQ2hELGlDQUF3QixDQUN6QjtZQUNELElBQUksQ0FBQyxrQkFBa0IsQ0FDckIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMscUJBQVksQ0FBQyxDQUFDLENBQUMsbUJBQVUsRUFDaEQsaUNBQXdCLENBQ3pCO1NBQ0YsQ0FBQztRQUVGLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLFVBQVUsQ0FBQyxNQUFNLENBQUM7Z0JBQ3ZCLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxxQkFBWSxFQUFFLGlDQUF3QixDQUFDO2dCQUNqRSxJQUFJLENBQUMsc0JBQXNCLENBQUMscUJBQVksRUFBRSxpQ0FBd0IsQ0FBQzthQUNwRSxDQUFDLENBQUM7U0FDSjthQUFNO1lBQ0wsT0FBTyxVQUFVLENBQUMsTUFBTSxDQUN0QixJQUFJLENBQUMsc0JBQXNCLENBQUMsbUJBQVUsRUFBRSxpQ0FBd0IsQ0FBQyxDQUNsRSxDQUFDO1NBQ0g7SUFDSCxDQUFDO0lBRVMsaUJBQWlCO1FBQ3pCLE9BQU8sSUFBSSxrQ0FBc0IsQ0FBQztZQUNoQyxNQUFNLEVBQUUsYUFBYTtZQUNyQixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7U0FDbEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVTLGVBQWUsQ0FBQyxLQUFhLEVBQUUsTUFBYztRQUNyRCxPQUFPLElBQUksNEJBQVcsQ0FBQztZQUNyQixLQUFLO1lBQ0wsTUFBTTtZQUNOLEtBQUssRUFBRSxpQkFBaUI7WUFDeEIsSUFBSSxFQUFFLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1lBQ2pDLFNBQVMsRUFBRSx3Q0FBK0I7WUFDMUMsZUFBZSxFQUFFLElBQUksQ0FBQyxtQkFBbUI7U0FDMUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVTLGtCQUFrQixDQUFDLEtBQWEsRUFBRSxNQUFjO1FBQ3hELE9BQU8sSUFBSSw0QkFBVyxDQUFDO1lBQ3JCLEtBQUs7WUFDTCxNQUFNO1lBQ04sS0FBSyxFQUFFLG9CQUFvQjtZQUMzQixJQUFJLEVBQUUsQ0FBQyxJQUFJLENBQUMsdUJBQXVCLENBQUM7WUFDcEMsU0FBUyxFQUFFLHdDQUErQjtZQUMxQyxlQUFlLEVBQUUsSUFBSSxDQUFDLHNCQUFzQjtTQUM3QyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRVMsc0JBQXNCLENBQUMsS0FBYSxFQUFFLE1BQWM7UUFDNUQsTUFBTSxJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUUzQyxJQUFJLElBQUksQ0FBQyxzQkFBc0IsRUFBRTtZQUMvQixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1NBQ3hDO1FBRUQsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEVBQUU7WUFDakMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsQ0FBQztTQUMxQztRQUVELE9BQU8sSUFBSSw0QkFBVyxDQUFDO1lBQ3JCLEtBQUs7WUFDTCxNQUFNO1lBQ04sS0FBSyxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsWUFBWTtZQUMxRCxJQUFJO1lBQ0osU0FBUyxFQUFFLDBCQUFpQjtZQUM1QixlQUFlLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtTQUM1QyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRVMsb0JBQW9CLENBQUMsS0FBYSxFQUFFLE1BQWM7UUFDMUQsTUFBTSxJQUFJLEdBQWMsRUFBRSxDQUFDO1FBQzNCLE1BQU0sS0FBSyxHQUFjLEVBQUUsQ0FBQztRQUU1QixJQUFJLElBQUksQ0FBQyx3QkFBd0IsRUFBRTtZQUNqQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1NBQzFDO1FBRUQsSUFBSSxJQUFJLENBQUMscUJBQXFCLEVBQUU7WUFDOUIsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsQ0FBQztTQUN2QztRQUVELElBQUksSUFBSSxDQUFDLG9CQUFvQixFQUFFO1lBQzdCLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLENBQUM7U0FDdkM7UUFFRCxPQUFPLElBQUksNEJBQVcsQ0FBQztZQUNyQixLQUFLO1lBQ0wsTUFBTTtZQUNOLEtBQUssRUFBRSxXQUFXO1lBQ2xCLElBQUk7WUFDSixTQUFTLEVBQUUsMEJBQWlCO1lBQzVCLEtBQUs7WUFDTCxVQUFVLEVBQUUsOEJBQXFCO1NBQ2xDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdFNILG9EQXVTQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIEdyYXBoV2lkZ2V0LFxuICBIb3Jpem9udGFsQW5ub3RhdGlvbixcbiAgSU1ldHJpYyxcbiAgSVdpZGdldCxcbn0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1jbG91ZHdhdGNoXCI7XG5pbXBvcnQgeyBFYzJTZXJ2aWNlIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1lY3NcIjtcbmltcG9ydCB7XG4gIEFwcGxpY2F0aW9uTG9hZEJhbGFuY2VkRWMyU2VydmljZSxcbiAgTmV0d29ya0xvYWRCYWxhbmNlZEVjMlNlcnZpY2UsXG59IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtZWNzLXBhdHRlcm5zXCI7XG5pbXBvcnQge1xuICBBcHBsaWNhdGlvbkxvYWRCYWxhbmNlcixcbiAgQXBwbGljYXRpb25UYXJnZXRHcm91cCxcbiAgTmV0d29ya0xvYWRCYWxhbmNlcixcbiAgTmV0d29ya1RhcmdldEdyb3VwLFxufSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjJcIjtcblxuaW1wb3J0IHtcbiAgQmFzZU1vbml0b3JpbmdQcm9wcyxcbiAgQ291bnRBeGlzRnJvbVplcm8sXG4gIERlZmF1bHRHcmFwaFdpZGdldEhlaWdodCxcbiAgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQsXG4gIEhlYWx0aHlUYXNrQ291bnRUaHJlc2hvbGQsXG4gIEhlYWx0aHlUYXNrUGVyY2VudFRocmVzaG9sZCxcbiAgTWV0cmljRmFjdG9yeSxcbiAgTWV0cmljV2l0aEFsYXJtU3VwcG9ydCxcbiAgTWluUHJvY2Vzc2VkQnl0ZXNUaHJlc2hvbGQsXG4gIE1vbml0b3JpbmcsXG4gIE1vbml0b3JpbmdTY29wZSxcbiAgTmV1dHJhbENvbG9yLFxuICBQZXJjZW50YWdlQXhpc0Zyb21aZXJvVG9IdW5kcmVkLFxuICBRdWFydGVyV2lkdGgsXG4gIFJ1bm5pbmdUYXNrQ291bnRUaHJlc2hvbGQsXG4gIFNpemVBeGlzQnl0ZXNGcm9tWmVybyxcbiAgVGFza0hlYWx0aEFsYXJtRmFjdG9yeSxcbiAgVGhpcmRXaWR0aCxcbiAgVGhyb3VnaHB1dEFsYXJtRmFjdG9yeSxcbiAgVW5oZWFsdGh5VGFza0NvdW50VGhyZXNob2xkLFxuICBVc2FnZUFsYXJtRmFjdG9yeSxcbiAgVXNhZ2VUaHJlc2hvbGQsXG59IGZyb20gXCIuLi8uLi9jb21tb25cIjtcbmltcG9ydCB7XG4gIE1vbml0b3JpbmdIZWFkZXJXaWRnZXQsXG4gIE1vbml0b3JpbmdOYW1pbmdTdHJhdGVneSxcbn0gZnJvbSBcIi4uLy4uL2Rhc2hib2FyZFwiO1xuaW1wb3J0IHtcbiAgQXBwbGljYXRpb25Mb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5UHJvcHMsXG4gIElMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5LFxuICBOZXR3b3JrTG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeVByb3BzLFxuICBjcmVhdGVMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5LFxufSBmcm9tIFwiLi4vYXdzLWxvYWRiYWxhbmNpbmdcIjtcbmltcG9ydCB7IEJhc2VTZXJ2aWNlTWV0cmljRmFjdG9yeSB9IGZyb20gXCIuL0Jhc2VTZXJ2aWNlTWV0cmljRmFjdG9yeVwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VFYzJTZXJ2aWNlQWxhcm1zIHtcbiAgLyoqXG4gICAqIG1pbmltdW0gbnVtYmVyIG9mIHRhc2tzLCBhcyBzcGVjaWZpZWQgaW4geW91ciBhdXRvIHNjYWxpbmcgY29uZmlnXG4gICAqL1xuICByZWFkb25seSBtaW5BdXRvU2NhbGluZ1Rhc2tDb3VudD86IG51bWJlcjtcbiAgLyoqXG4gICAqIG1heGltdW0gbnVtYmVyIG9mIHRhc2tzLCBhcyBzcGVjaWZpZWQgaW4geW91ciBhdXRvIHNjYWxpbmcgY29uZmlnXG4gICAqL1xuICByZWFkb25seSBtYXhBdXRvU2NhbGluZ1Rhc2tDb3VudD86IG51bWJlcjtcbiAgLyoqXG4gICAqIENvbnRhaW5lciBJbnNpZ2h0cyBuZWVkcyB0byBiZSBlbmFibGVkIGZvciB0aGUgY2x1c3RlciBmb3IgdGhpcyBhbGFybVxuICAgKi9cbiAgcmVhZG9ubHkgYWRkUnVubmluZ1Rhc2tDb3VudEFsYXJtPzogUmVjb3JkPHN0cmluZywgUnVubmluZ1Rhc2tDb3VudFRocmVzaG9sZD47XG4gIHJlYWRvbmx5IGFkZENwdVVzYWdlQWxhcm0/OiBSZWNvcmQ8c3RyaW5nLCBVc2FnZVRocmVzaG9sZD47XG4gIHJlYWRvbmx5IGFkZE1lbW9yeVVzYWdlQWxhcm0/OiBSZWNvcmQ8c3RyaW5nLCBVc2FnZVRocmVzaG9sZD47XG59XG5cbi8qKlxuICogTW9uaXRvcmluZyBwcm9wcyBmb3IgYW55IHR5cGUgb2YgRUMyIHNlcnZpY2UuXG4gKi9cbmludGVyZmFjZSBCYXNlRWMyU2VydmljZU1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIEJhc2VNb25pdG9yaW5nUHJvcHMsXG4gICAgQmFzZUVjMlNlcnZpY2VBbGFybXMge31cblxuLyoqXG4gKiBNb25pdG9yaW5nIHByb3BzIGZvciBTaW1wbGUgRUMyIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU2ltcGxlRWMyU2VydmljZU1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIEJhc2VFYzJTZXJ2aWNlTW9uaXRvcmluZ1Byb3BzIHtcbiAgcmVhZG9ubHkgZWMyU2VydmljZTogRWMyU2VydmljZTtcbn1cblxuLyoqXG4gKiBCYXNlIG9mIE1vbml0b3JpbmcgcHJvcHMgZm9yIGxvYWQtYmFsYW5jZWQgRUMyIHNlcnZpY2UuXG4gKi9cbmludGVyZmFjZSBCYXNlTG9hZEJhbGFuY2VkRWMyU2VydmljZU1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIEJhc2VFYzJTZXJ2aWNlTW9uaXRvcmluZ1Byb3BzIHtcbiAgcmVhZG9ubHkgYWRkSGVhbHRoeVRhc2tDb3VudEFsYXJtPzogUmVjb3JkPHN0cmluZywgSGVhbHRoeVRhc2tDb3VudFRocmVzaG9sZD47XG4gIHJlYWRvbmx5IGFkZFVuaGVhbHRoeVRhc2tDb3VudEFsYXJtPzogUmVjb3JkPFxuICAgIHN0cmluZyxcbiAgICBVbmhlYWx0aHlUYXNrQ291bnRUaHJlc2hvbGRcbiAgPjtcbiAgcmVhZG9ubHkgYWRkSGVhbHRoeVRhc2tQZXJjZW50QWxhcm0/OiBSZWNvcmQ8XG4gICAgc3RyaW5nLFxuICAgIEhlYWx0aHlUYXNrUGVyY2VudFRocmVzaG9sZFxuICA+O1xuICByZWFkb25seSBhZGRNaW5Qcm9jZXNzZWRCeXRlc0FsYXJtPzogUmVjb3JkPFxuICAgIHN0cmluZyxcbiAgICBNaW5Qcm9jZXNzZWRCeXRlc1RocmVzaG9sZFxuICA+O1xufVxuXG4vKipcbiAqIE1vbml0b3JpbmcgcHJvcHMgZm9yIGxvYWQtYmFsYW5jZWQgRUMyIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRWMyU2VydmljZU1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIEJhc2VMb2FkQmFsYW5jZWRFYzJTZXJ2aWNlTW9uaXRvcmluZ1Byb3BzIHtcbiAgcmVhZG9ubHkgZWMyU2VydmljZTpcbiAgICB8IE5ldHdvcmtMb2FkQmFsYW5jZWRFYzJTZXJ2aWNlXG4gICAgfCBBcHBsaWNhdGlvbkxvYWRCYWxhbmNlZEVjMlNlcnZpY2U7XG59XG5cbi8qKlxuICogTW9uaXRvcmluZyBwcm9wcyBmb3IgRUMyIHNlcnZpY2Ugd2l0aCBuZXR3b3JrIGxvYWQgYmFsYW5jZXIgYW5kIHBsYWluIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRWMyTmV0d29ya0xvYWRCYWxhbmNlck1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIE5ldHdvcmtMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5UHJvcHMsXG4gICAgQmFzZUxvYWRCYWxhbmNlZEVjMlNlcnZpY2VNb25pdG9yaW5nUHJvcHMge1xuICByZWFkb25seSBlYzJTZXJ2aWNlOiBFYzJTZXJ2aWNlO1xufVxuXG4vKipcbiAqIE1vbml0b3JpbmcgcHJvcHMgZm9yIEVDMiBzZXJ2aWNlIHdpdGggYXBwbGljYXRpb24gbG9hZCBiYWxhbmNlciBhbmQgcGxhaW4gc2VydmljZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFYzJBcHBsaWNhdGlvbkxvYWRCYWxhbmNlck1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIEFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeVByb3BzLFxuICAgIEJhc2VMb2FkQmFsYW5jZWRFYzJTZXJ2aWNlTW9uaXRvcmluZ1Byb3BzIHtcbiAgcmVhZG9ubHkgZWMyU2VydmljZTogRWMyU2VydmljZTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDdXN0b21FYzJTZXJ2aWNlTW9uaXRvcmluZ1Byb3BzXG4gIGV4dGVuZHMgQmFzZUxvYWRCYWxhbmNlZEVjMlNlcnZpY2VNb25pdG9yaW5nUHJvcHMge1xuICByZWFkb25seSBlYzJTZXJ2aWNlOiBFYzJTZXJ2aWNlO1xuICByZWFkb25seSBsb2FkQmFsYW5jZXI/OiBBcHBsaWNhdGlvbkxvYWRCYWxhbmNlciB8IE5ldHdvcmtMb2FkQmFsYW5jZXI7XG4gIHJlYWRvbmx5IHRhcmdldEdyb3VwPzogQXBwbGljYXRpb25UYXJnZXRHcm91cCB8IE5ldHdvcmtUYXJnZXRHcm91cDtcbn1cblxuZXhwb3J0IGNsYXNzIEVjMlNlcnZpY2VNb25pdG9yaW5nIGV4dGVuZHMgTW9uaXRvcmluZyB7XG4gIHByb3RlY3RlZCByZWFkb25seSB0aXRsZTogc3RyaW5nO1xuXG4gIHByb3RlY3RlZCByZWFkb25seSBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5OiBCYXNlU2VydmljZU1ldHJpY0ZhY3Rvcnk7XG4gIHByb3RlY3RlZCByZWFkb25seSBsb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5PzogSUxvYWRCYWxhbmNlck1ldHJpY0ZhY3Rvcnk7XG5cbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tIZWFsdGhBbGFybUZhY3Rvcnk6IFRhc2tIZWFsdGhBbGFybUZhY3Rvcnk7XG4gIHByb3RlY3RlZCByZWFkb25seSB0aHJvdWdocHV0QWxhcm1GYWN0b3J5OiBUaHJvdWdocHV0QWxhcm1GYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza0hlYWx0aEFubm90YXRpb25zOiBIb3Jpem9udGFsQW5ub3RhdGlvbltdO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdXNhZ2VBbGFybUZhY3Rvcnk6IFVzYWdlQWxhcm1GYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgY3B1VXNhZ2VBbm5vdGF0aW9uczogSG9yaXpvbnRhbEFubm90YXRpb25bXTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG1lbW9yeVVzYWdlQW5ub3RhdGlvbnM6IEhvcml6b250YWxBbm5vdGF0aW9uW107XG4gIHByb3RlY3RlZCByZWFkb25seSBwcm9jZXNzZWRCeXRlc0Fubm90YXRpb25zOiBIb3Jpem9udGFsQW5ub3RhdGlvbltdO1xuXG4gIHByb3RlY3RlZCByZWFkb25seSBoZWFsdGh5VGFza0NvdW50TWV0cmljPzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHVuaGVhbHRoeVRhc2tDb3VudE1ldHJpYz86IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQ7XG4gIHByb3RlY3RlZCByZWFkb25seSBoZWFsdGh5VGFza1BlcmNlbnRNZXRyaWM/OiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgcnVubmluZ1Rhc2tDb3VudE1ldHJpYzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGNwdVV0aWxpc2F0aW9uTWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbWVtb3J5VXRpbGlzYXRpb25NZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQ7XG4gIHByb3RlY3RlZCByZWFkb25seSBhY3RpdmVUY3BGbG93Q291bnRNZXRyaWM/OiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbmV3VGNwRmxvd0NvdW50TWV0cmljPzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHByb2Nlc3NlZEJ5dGVzTWV0cmljPzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydDtcblxuICBwcml2YXRlIGhhc0xvYWRCYWxhbmNlcjogYm9vbGVhbjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogTW9uaXRvcmluZ1Njb3BlLCBwcm9wczogQ3VzdG9tRWMyU2VydmljZU1vbml0b3JpbmdQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBwcm9wcyk7XG5cbiAgICB0aGlzLmhhc0xvYWRCYWxhbmNlciA9XG4gICAgICBwcm9wcy5sb2FkQmFsYW5jZXIgIT09IHVuZGVmaW5lZCAmJiBwcm9wcy50YXJnZXRHcm91cCAhPT0gdW5kZWZpbmVkO1xuXG4gICAgY29uc3QgbmFtaW5nU3RyYXRlZ3kgPSBuZXcgTW9uaXRvcmluZ05hbWluZ1N0cmF0ZWd5KHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgbmFtZWRDb25zdHJ1Y3Q6IHByb3BzLmVjMlNlcnZpY2UsXG4gICAgfSk7XG4gICAgdGhpcy50aXRsZSA9IG5hbWluZ1N0cmF0ZWd5LnJlc29sdmVIdW1hblJlYWRhYmxlTmFtZSgpO1xuXG4gICAgdGhpcy5tZXRyaWNGYWN0b3J5ID0gc2NvcGUuY3JlYXRlTWV0cmljRmFjdG9yeSgpO1xuICAgIHRoaXMuYmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5ID0gbmV3IEJhc2VTZXJ2aWNlTWV0cmljRmFjdG9yeShcbiAgICAgIHRoaXMubWV0cmljRmFjdG9yeSxcbiAgICAgIHsgc2VydmljZTogcHJvcHMuZWMyU2VydmljZSB9XG4gICAgKTtcbiAgICBpZiAodGhpcy5oYXNMb2FkQmFsYW5jZXIpIHtcbiAgICAgIHRoaXMubG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeSA9IGNyZWF0ZUxvYWRCYWxhbmNlck1ldHJpY0ZhY3RvcnkoXG4gICAgICAgIHRoaXMubWV0cmljRmFjdG9yeSxcbiAgICAgICAgcHJvcHMubG9hZEJhbGFuY2VyLFxuICAgICAgICBwcm9wcy50YXJnZXRHcm91cFxuICAgICAgKTtcbiAgICAgIHRoaXMuaGVhbHRoeVRhc2tDb3VudE1ldHJpYyA9XG4gICAgICAgIHRoaXMubG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeS5tZXRyaWNIZWFsdGh5VGFza0NvdW50KCk7XG4gICAgICB0aGlzLnVuaGVhbHRoeVRhc2tDb3VudE1ldHJpYyA9XG4gICAgICAgIHRoaXMubG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeS5tZXRyaWNVbmhlYWx0aHlUYXNrQ291bnQoKTtcbiAgICAgIHRoaXMuaGVhbHRoeVRhc2tQZXJjZW50TWV0cmljID1cbiAgICAgICAgdGhpcy5sb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5Lm1ldHJpY0hlYWx0aHlUYXNrSW5QZXJjZW50KCk7XG4gICAgICB0aGlzLmFjdGl2ZVRjcEZsb3dDb3VudE1ldHJpYyA9XG4gICAgICAgIHRoaXMubG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeS5tZXRyaWNBY3RpdmVDb25uZWN0aW9uQ291bnQoKTtcbiAgICAgIHRoaXMubmV3VGNwRmxvd0NvdW50TWV0cmljID1cbiAgICAgICAgdGhpcy5sb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5Lm1ldHJpY05ld0Nvbm5lY3Rpb25Db3VudCgpO1xuICAgICAgdGhpcy5wcm9jZXNzZWRCeXRlc01ldHJpYyA9XG4gICAgICAgIHRoaXMubG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeS5tZXRyaWNQcm9jZXNzZWRCeXRlc01pbigpO1xuICAgIH1cbiAgICB0aGlzLnJ1bm5pbmdUYXNrQ291bnRNZXRyaWMgPVxuICAgICAgdGhpcy5iYXNlU2VydmljZU1ldHJpY0ZhY3RvcnkubWV0cmljUnVubmluZ1Rhc2tDb3VudCgpO1xuICAgIHRoaXMuY3B1VXRpbGlzYXRpb25NZXRyaWMgPVxuICAgICAgdGhpcy5iYXNlU2VydmljZU1ldHJpY0ZhY3RvcnkubWV0cmljQ2x1c3RlckNwdVV0aWxpc2F0aW9uSW5QZXJjZW50KCk7XG4gICAgdGhpcy5tZW1vcnlVdGlsaXNhdGlvbk1ldHJpYyA9XG4gICAgICB0aGlzLmJhc2VTZXJ2aWNlTWV0cmljRmFjdG9yeS5tZXRyaWNDbHVzdGVyTWVtb3J5VXRpbGlzYXRpb25JblBlcmNlbnQoKTtcblxuICAgIGNvbnN0IGFsYXJtRmFjdG9yeSA9IHRoaXMuY3JlYXRlQWxhcm1GYWN0b3J5KFxuICAgICAgbmFtaW5nU3RyYXRlZ3kucmVzb2x2ZUFsYXJtRnJpZW5kbHlOYW1lKClcbiAgICApO1xuICAgIHRoaXMudGFza0hlYWx0aEFsYXJtRmFjdG9yeSA9IG5ldyBUYXNrSGVhbHRoQWxhcm1GYWN0b3J5KGFsYXJtRmFjdG9yeSk7XG4gICAgdGhpcy50aHJvdWdocHV0QWxhcm1GYWN0b3J5ID0gbmV3IFRocm91Z2hwdXRBbGFybUZhY3RvcnkoYWxhcm1GYWN0b3J5KTtcbiAgICB0aGlzLnRhc2tIZWFsdGhBbm5vdGF0aW9ucyA9IFtdO1xuICAgIHRoaXMudXNhZ2VBbGFybUZhY3RvcnkgPSBuZXcgVXNhZ2VBbGFybUZhY3RvcnkoYWxhcm1GYWN0b3J5KTtcbiAgICB0aGlzLmNwdVVzYWdlQW5ub3RhdGlvbnMgPSBbXTtcbiAgICB0aGlzLm1lbW9yeVVzYWdlQW5ub3RhdGlvbnMgPSBbXTtcbiAgICB0aGlzLnByb2Nlc3NlZEJ5dGVzQW5ub3RhdGlvbnMgPSBbXTtcblxuICAgIGlmIChwcm9wcy5taW5BdXRvU2NhbGluZ1Rhc2tDb3VudCkge1xuICAgICAgLy8gVE9ETzogdXNlIGFubm90YXRpb24gc3RyYXRlZ3kgdG8gY3JlYXRlIG5ldXRyYWwgYW5ub3RhdGlvblxuICAgICAgdGhpcy50YXNrSGVhbHRoQW5ub3RhdGlvbnMucHVzaCh7XG4gICAgICAgIHZhbHVlOiBwcm9wcy5taW5BdXRvU2NhbGluZ1Rhc2tDb3VudCxcbiAgICAgICAgbGFiZWw6IFwiQXV0b1NjYWxpbmc6IE1pblwiLFxuICAgICAgICBjb2xvcjogTmV1dHJhbENvbG9yLFxuICAgICAgfSk7XG4gICAgfVxuICAgIGlmIChwcm9wcy5tYXhBdXRvU2NhbGluZ1Rhc2tDb3VudCkge1xuICAgICAgLy8gVE9ETzogdXNlIGFubm90YXRpb24gc3RyYXRlZ3kgdG8gY3JlYXRlIG5ldXRyYWwgYW5ub3RhdGlvblxuICAgICAgdGhpcy50YXNrSGVhbHRoQW5ub3RhdGlvbnMucHVzaCh7XG4gICAgICAgIHZhbHVlOiBwcm9wcy5tYXhBdXRvU2NhbGluZ1Rhc2tDb3VudCxcbiAgICAgICAgbGFiZWw6IFwiQXV0b1NjYWxpbmc6IE1heFwiLFxuICAgICAgICBjb2xvcjogTmV1dHJhbENvbG9yLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaGFzTG9hZEJhbGFuY2VyKSB7XG4gICAgICBmb3IgKGNvbnN0IGRpc2FtYmlndWF0b3IgaW4gcHJvcHMuYWRkSGVhbHRoeVRhc2tDb3VudEFsYXJtKSB7XG4gICAgICAgIGNvbnN0IGFsYXJtUHJvcHMgPSBwcm9wcy5hZGRIZWFsdGh5VGFza0NvdW50QWxhcm1bZGlzYW1iaWd1YXRvcl07XG4gICAgICAgIGNvbnN0IGNyZWF0ZWRBbGFybSA9XG4gICAgICAgICAgdGhpcy50YXNrSGVhbHRoQWxhcm1GYWN0b3J5LmFkZEhlYWx0aHlUYXNrQ291bnRBbGFybShcbiAgICAgICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tbm9uLW51bGwtYXNzZXJ0aW9uXG4gICAgICAgICAgICB0aGlzLmhlYWx0aHlUYXNrQ291bnRNZXRyaWMhLFxuICAgICAgICAgICAgYWxhcm1Qcm9wcyxcbiAgICAgICAgICAgIGRpc2FtYmlndWF0b3JcbiAgICAgICAgICApO1xuICAgICAgICB0aGlzLnRhc2tIZWFsdGhBbm5vdGF0aW9ucy5wdXNoKGNyZWF0ZWRBbGFybS5hbm5vdGF0aW9uKTtcbiAgICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgICAgfVxuICAgICAgZm9yIChjb25zdCBkaXNhbWJpZ3VhdG9yIGluIHByb3BzLmFkZFVuaGVhbHRoeVRhc2tDb3VudEFsYXJtKSB7XG4gICAgICAgIGNvbnN0IGFsYXJtUHJvcHMgPSBwcm9wcy5hZGRVbmhlYWx0aHlUYXNrQ291bnRBbGFybVtkaXNhbWJpZ3VhdG9yXTtcbiAgICAgICAgY29uc3QgY3JlYXRlZEFsYXJtID1cbiAgICAgICAgICB0aGlzLnRhc2tIZWFsdGhBbGFybUZhY3RvcnkuYWRkVW5oZWFsdGh5VGFza0NvdW50QWxhcm0oXG4gICAgICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLW5vbi1udWxsLWFzc2VydGlvblxuICAgICAgICAgICAgdGhpcy51bmhlYWx0aHlUYXNrQ291bnRNZXRyaWMhLFxuICAgICAgICAgICAgYWxhcm1Qcm9wcyxcbiAgICAgICAgICAgIGRpc2FtYmlndWF0b3JcbiAgICAgICAgICApO1xuICAgICAgICB0aGlzLnRhc2tIZWFsdGhBbm5vdGF0aW9ucy5wdXNoKGNyZWF0ZWRBbGFybS5hbm5vdGF0aW9uKTtcbiAgICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgICAgfVxuICAgICAgZm9yIChjb25zdCBkaXNhbWJpZ3VhdG9yIGluIHByb3BzLmFkZEhlYWx0aHlUYXNrUGVyY2VudEFsYXJtKSB7XG4gICAgICAgIGNvbnN0IGFsYXJtUHJvcHMgPSBwcm9wcy5hZGRIZWFsdGh5VGFza1BlcmNlbnRBbGFybVtkaXNhbWJpZ3VhdG9yXTtcbiAgICAgICAgY29uc3QgY3JlYXRlZEFsYXJtID1cbiAgICAgICAgICB0aGlzLnRhc2tIZWFsdGhBbGFybUZhY3RvcnkuYWRkSGVhbHRoeVRhc2tQZXJjZW50QWxhcm0oXG4gICAgICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLW5vbi1udWxsLWFzc2VydGlvblxuICAgICAgICAgICAgdGhpcy5oZWFsdGh5VGFza1BlcmNlbnRNZXRyaWMhLFxuICAgICAgICAgICAgYWxhcm1Qcm9wcyxcbiAgICAgICAgICAgIGRpc2FtYmlndWF0b3JcbiAgICAgICAgICApO1xuICAgICAgICB0aGlzLmFkZEFsYXJtKGNyZWF0ZWRBbGFybSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgZm9yIChjb25zdCBkaXNhbWJpZ3VhdG9yIGluIHByb3BzLmFkZFJ1bm5pbmdUYXNrQ291bnRBbGFybSkge1xuICAgICAgY29uc3QgYWxhcm1Qcm9wcyA9IHByb3BzLmFkZFJ1bm5pbmdUYXNrQ291bnRBbGFybVtkaXNhbWJpZ3VhdG9yXTtcbiAgICAgIGNvbnN0IGNyZWF0ZWRBbGFybSA9IHRoaXMudGFza0hlYWx0aEFsYXJtRmFjdG9yeS5hZGRSdW5uaW5nVGFza0NvdW50QWxhcm0oXG4gICAgICAgIHRoaXMucnVubmluZ1Rhc2tDb3VudE1ldHJpYyxcbiAgICAgICAgYWxhcm1Qcm9wcyxcbiAgICAgICAgZGlzYW1iaWd1YXRvclxuICAgICAgKTtcbiAgICAgIHRoaXMudGFza0hlYWx0aEFubm90YXRpb25zLnB1c2goY3JlYXRlZEFsYXJtLmFubm90YXRpb24pO1xuICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IGRpc2FtYmlndWF0b3IgaW4gcHJvcHMuYWRkQ3B1VXNhZ2VBbGFybSkge1xuICAgICAgY29uc3QgYWxhcm1Qcm9wcyA9IHByb3BzLmFkZENwdVVzYWdlQWxhcm1bZGlzYW1iaWd1YXRvcl07XG4gICAgICBjb25zdCBjcmVhdGVkQWxhcm0gPSB0aGlzLnVzYWdlQWxhcm1GYWN0b3J5LmFkZE1heENwdVVzYWdlUGVyY2VudEFsYXJtKFxuICAgICAgICB0aGlzLmNwdVV0aWxpc2F0aW9uTWV0cmljLFxuICAgICAgICBhbGFybVByb3BzLFxuICAgICAgICBkaXNhbWJpZ3VhdG9yXG4gICAgICApO1xuICAgICAgdGhpcy5jcHVVc2FnZUFubm90YXRpb25zLnB1c2goY3JlYXRlZEFsYXJtLmFubm90YXRpb24pO1xuICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IGRpc2FtYmlndWF0b3IgaW4gcHJvcHMuYWRkTWVtb3J5VXNhZ2VBbGFybSkge1xuICAgICAgY29uc3QgYWxhcm1Qcm9wcyA9IHByb3BzLmFkZE1lbW9yeVVzYWdlQWxhcm1bZGlzYW1iaWd1YXRvcl07XG4gICAgICBjb25zdCBjcmVhdGVkQWxhcm0gPSB0aGlzLnVzYWdlQWxhcm1GYWN0b3J5LmFkZE1heE1lbW9yeVVzYWdlUGVyY2VudEFsYXJtKFxuICAgICAgICB0aGlzLm1lbW9yeVV0aWxpc2F0aW9uTWV0cmljLFxuICAgICAgICBhbGFybVByb3BzLFxuICAgICAgICBkaXNhbWJpZ3VhdG9yXG4gICAgICApO1xuICAgICAgdGhpcy5tZW1vcnlVc2FnZUFubm90YXRpb25zLnB1c2goY3JlYXRlZEFsYXJtLmFubm90YXRpb24pO1xuICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmhhc0xvYWRCYWxhbmNlcikge1xuICAgICAgZm9yIChjb25zdCBkaXNhbWJpZ3VhdG9yIGluIHByb3BzLmFkZE1pblByb2Nlc3NlZEJ5dGVzQWxhcm0pIHtcbiAgICAgICAgY29uc3QgYWxhcm1Qcm9wcyA9IHByb3BzLmFkZE1pblByb2Nlc3NlZEJ5dGVzQWxhcm1bZGlzYW1iaWd1YXRvcl07XG4gICAgICAgIGNvbnN0IGNyZWF0ZWRBbGFybSA9XG4gICAgICAgICAgdGhpcy50aHJvdWdocHV0QWxhcm1GYWN0b3J5LmFkZE1pblByb2Nlc3NlZEJ5dGVzQWxhcm0oXG4gICAgICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLW5vbi1udWxsLWFzc2VydGlvblxuICAgICAgICAgICAgdGhpcy5wcm9jZXNzZWRCeXRlc01ldHJpYyEsXG4gICAgICAgICAgICBhbGFybVByb3BzLFxuICAgICAgICAgICAgZGlzYW1iaWd1YXRvclxuICAgICAgICAgICk7XG4gICAgICAgIHRoaXMucHJvY2Vzc2VkQnl0ZXNBbm5vdGF0aW9ucy5wdXNoKGNyZWF0ZWRBbGFybS5hbm5vdGF0aW9uKTtcbiAgICAgICAgdGhpcy5hZGRBbGFybShjcmVhdGVkQWxhcm0pO1xuICAgICAgfVxuICAgIH1cblxuICAgIHByb3BzLnVzZUNyZWF0ZWRBbGFybXM/LmNvbnN1bWUodGhpcy5jcmVhdGVkQWxhcm1zKCkpO1xuICB9XG5cbiAgc3VtbWFyeVdpZGdldHMoKTogSVdpZGdldFtdIHtcbiAgICByZXR1cm4gW1xuICAgICAgdGhpcy5jcmVhdGVUaXRsZVdpZGdldCgpLFxuICAgICAgdGhpcy5jcmVhdGVDcHVXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVNZW1vcnlXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVUYXNrSGVhbHRoV2lkZ2V0KFRoaXJkV2lkdGgsIERlZmF1bHRTdW1tYXJ5V2lkZ2V0SGVpZ2h0KSxcbiAgICBdO1xuICB9XG5cbiAgd2lkZ2V0cygpOiBJV2lkZ2V0W10ge1xuICAgIGNvbnN0IGJhc2VXaWRnZXQgPSBbXG4gICAgICB0aGlzLmNyZWF0ZVRpdGxlV2lkZ2V0KCksXG4gICAgICB0aGlzLmNyZWF0ZUNwdVdpZGdldChcbiAgICAgICAgdGhpcy5oYXNMb2FkQmFsYW5jZXIgPyBRdWFydGVyV2lkdGggOiBUaGlyZFdpZHRoLFxuICAgICAgICBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHRcbiAgICAgICksXG4gICAgICB0aGlzLmNyZWF0ZU1lbW9yeVdpZGdldChcbiAgICAgICAgdGhpcy5oYXNMb2FkQmFsYW5jZXIgPyBRdWFydGVyV2lkdGggOiBUaGlyZFdpZHRoLFxuICAgICAgICBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHRcbiAgICAgICksXG4gICAgXTtcblxuICAgIGlmICh0aGlzLmhhc0xvYWRCYWxhbmNlcikge1xuICAgICAgcmV0dXJuIGJhc2VXaWRnZXQuY29uY2F0KFtcbiAgICAgICAgdGhpcy5jcmVhdGVUcGNGbG93c1dpZGdldChRdWFydGVyV2lkdGgsIERlZmF1bHRHcmFwaFdpZGdldEhlaWdodCksXG4gICAgICAgIHRoaXMuY3JlYXRlVGFza0hlYWx0aFdpZGdldChRdWFydGVyV2lkdGgsIERlZmF1bHRHcmFwaFdpZGdldEhlaWdodCksXG4gICAgICBdKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIGJhc2VXaWRnZXQuY29uY2F0KFxuICAgICAgICB0aGlzLmNyZWF0ZVRhc2tIZWFsdGhXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdEdyYXBoV2lkZ2V0SGVpZ2h0KVxuICAgICAgKTtcbiAgICB9XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVGl0bGVXaWRnZXQoKSB7XG4gICAgcmV0dXJuIG5ldyBNb25pdG9yaW5nSGVhZGVyV2lkZ2V0KHtcbiAgICAgIGZhbWlseTogXCJFYzIgU2VydmljZVwiLFxuICAgICAgdGl0bGU6IHRoaXMudGl0bGUsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlQ3B1V2lkZ2V0KHdpZHRoOiBudW1iZXIsIGhlaWdodDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHRpdGxlOiBcIkNQVSBVdGlsaXphdGlvblwiLFxuICAgICAgbGVmdDogW3RoaXMuY3B1VXRpbGlzYXRpb25NZXRyaWNdLFxuICAgICAgbGVmdFlBeGlzOiBQZXJjZW50YWdlQXhpc0Zyb21aZXJvVG9IdW5kcmVkLFxuICAgICAgbGVmdEFubm90YXRpb25zOiB0aGlzLmNwdVVzYWdlQW5ub3RhdGlvbnMsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlTWVtb3J5V2lkZ2V0KHdpZHRoOiBudW1iZXIsIGhlaWdodDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHRpdGxlOiBcIk1lbW9yeSBVdGlsaXphdGlvblwiLFxuICAgICAgbGVmdDogW3RoaXMubWVtb3J5VXRpbGlzYXRpb25NZXRyaWNdLFxuICAgICAgbGVmdFlBeGlzOiBQZXJjZW50YWdlQXhpc0Zyb21aZXJvVG9IdW5kcmVkLFxuICAgICAgbGVmdEFubm90YXRpb25zOiB0aGlzLm1lbW9yeVVzYWdlQW5ub3RhdGlvbnMsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVGFza0hlYWx0aFdpZGdldCh3aWR0aDogbnVtYmVyLCBoZWlnaHQ6IG51bWJlcikge1xuICAgIGNvbnN0IGxlZnQgPSBbdGhpcy5ydW5uaW5nVGFza0NvdW50TWV0cmljXTtcblxuICAgIGlmICh0aGlzLmhlYWx0aHlUYXNrQ291bnRNZXRyaWMpIHtcbiAgICAgIGxlZnQucHVzaCh0aGlzLmhlYWx0aHlUYXNrQ291bnRNZXRyaWMpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnVuaGVhbHRoeVRhc2tDb3VudE1ldHJpYykge1xuICAgICAgbGVmdC5wdXNoKHRoaXMudW5oZWFsdGh5VGFza0NvdW50TWV0cmljKTtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEdyYXBoV2lkZ2V0KHtcbiAgICAgIHdpZHRoLFxuICAgICAgaGVpZ2h0LFxuICAgICAgdGl0bGU6IHRoaXMuaGFzTG9hZEJhbGFuY2VyID8gXCJUYXNrIEhlYWx0aFwiIDogXCJUYXNrIENvdW50XCIsXG4gICAgICBsZWZ0LFxuICAgICAgbGVmdFlBeGlzOiBDb3VudEF4aXNGcm9tWmVybyxcbiAgICAgIGxlZnRBbm5vdGF0aW9uczogdGhpcy50YXNrSGVhbHRoQW5ub3RhdGlvbnMsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVHBjRmxvd3NXaWRnZXQod2lkdGg6IG51bWJlciwgaGVpZ2h0OiBudW1iZXIpIHtcbiAgICBjb25zdCBsZWZ0OiBJTWV0cmljW10gPSBbXTtcbiAgICBjb25zdCByaWdodDogSU1ldHJpY1tdID0gW107XG5cbiAgICBpZiAodGhpcy5hY3RpdmVUY3BGbG93Q291bnRNZXRyaWMpIHtcbiAgICAgIGxlZnQucHVzaCh0aGlzLmFjdGl2ZVRjcEZsb3dDb3VudE1ldHJpYyk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMubmV3VGNwRmxvd0NvdW50TWV0cmljKSB7XG4gICAgICBsZWZ0LnB1c2godGhpcy5uZXdUY3BGbG93Q291bnRNZXRyaWMpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb2Nlc3NlZEJ5dGVzTWV0cmljKSB7XG4gICAgICByaWdodC5wdXNoKHRoaXMucHJvY2Vzc2VkQnl0ZXNNZXRyaWMpO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgR3JhcGhXaWRnZXQoe1xuICAgICAgd2lkdGgsXG4gICAgICBoZWlnaHQsXG4gICAgICB0aXRsZTogXCJUQ1AgRmxvd3NcIixcbiAgICAgIGxlZnQsXG4gICAgICBsZWZ0WUF4aXM6IENvdW50QXhpc0Zyb21aZXJvLFxuICAgICAgcmlnaHQsXG4gICAgICByaWdodFlBeGlzOiBTaXplQXhpc0J5dGVzRnJvbVplcm8sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==