import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { FargateService } from "aws-cdk-lib/aws-ecs";
import { ApplicationLoadBalancedFargateService, NetworkLoadBalancedFargateService } from "aws-cdk-lib/aws-ecs-patterns";
import { ApplicationLoadBalancer, ApplicationTargetGroup, NetworkLoadBalancer, NetworkTargetGroup } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { BaseMonitoringProps, HealthyTaskCountThreshold, HealthyTaskPercentThreshold, MetricFactory, MetricWithAlarmSupport, MinProcessedBytesThreshold, Monitoring, MonitoringScope, RunningTaskCountThreshold, TaskHealthAlarmFactory, ThroughputAlarmFactory, UnhealthyTaskCountThreshold, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { ApplicationLoadBalancerMetricFactoryProps, ILoadBalancerMetricFactory, NetworkLoadBalancerMetricFactoryProps } from "../aws-loadbalancing";
import { BaseServiceMetricFactory } from "./BaseServiceMetricFactory";
export interface BaseFargateServiceAlarms {
    /**
     * minimum number of tasks, as specified in your auto scaling config
     */
    readonly minAutoScalingTaskCount?: number;
    /**
     * maximum number of tasks, as specified in your auto scaling config
     */
    readonly maxAutoScalingTaskCount?: number;
    /**
     * Container Insights needs to be enabled for the cluster for this alarm
     */
    readonly addRunningTaskCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
    readonly addMemoryUsageAlarm?: Record<string, UsageThreshold>;
}
/**
 * Monitoring props for any type of Fargate service.
 */
interface BaseFargateServiceMonitoringProps extends BaseMonitoringProps, BaseFargateServiceAlarms {
}
/**
 * Monitoring props for Simple Fargate service.
 */
export interface SimpleFargateServiceMonitoringProps extends BaseFargateServiceMonitoringProps {
    readonly fargateService: FargateService;
}
/**
 * Base of Monitoring props for load-balanced Fargate service.
 */
interface BaseLoadBalancedFargateServiceMonitoringProps extends BaseFargateServiceMonitoringProps {
    readonly addHealthyTaskCountAlarm?: Record<string, HealthyTaskCountThreshold>;
    readonly addUnhealthyTaskCountAlarm?: Record<string, UnhealthyTaskCountThreshold>;
    readonly addHealthyTaskPercentAlarm?: Record<string, HealthyTaskPercentThreshold>;
    readonly addMinProcessedBytesAlarm?: Record<string, MinProcessedBytesThreshold>;
}
/**
 * Monitoring props for load-balanced Fargate service.
 */
export interface FargateServiceMonitoringProps extends BaseLoadBalancedFargateServiceMonitoringProps {
    readonly fargateService: NetworkLoadBalancedFargateService | ApplicationLoadBalancedFargateService;
}
/**
 * Monitoring props for Fargate service with network load balancer and plain service.
 */
export interface FargateNetworkLoadBalancerMonitoringProps extends NetworkLoadBalancerMetricFactoryProps, BaseLoadBalancedFargateServiceMonitoringProps {
    readonly fargateService: FargateService;
}
/**
 * Monitoring props for Fargate service with application load balancer and plain service.
 */
export interface FargateApplicationLoadBalancerMonitoringProps extends ApplicationLoadBalancerMetricFactoryProps, BaseLoadBalancedFargateServiceMonitoringProps {
    readonly fargateService: FargateService;
}
export interface CustomFargateServiceMonitoringProps extends BaseLoadBalancedFargateServiceMonitoringProps {
    readonly fargateService: FargateService;
    readonly loadBalancer?: ApplicationLoadBalancer | NetworkLoadBalancer;
    readonly targetGroup?: ApplicationTargetGroup | NetworkTargetGroup;
}
export declare class FargateServiceMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly metricFactory: MetricFactory;
    protected readonly baseServiceMetricFactory: BaseServiceMetricFactory;
    protected readonly loadBalancerMetricFactory?: ILoadBalancerMetricFactory;
    protected readonly taskHealthAlarmFactory: TaskHealthAlarmFactory;
    protected readonly throughputAlarmFactory: ThroughputAlarmFactory;
    protected readonly taskHealthAnnotations: HorizontalAnnotation[];
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly cpuUsageAnnotations: HorizontalAnnotation[];
    protected readonly memoryUsageAnnotations: HorizontalAnnotation[];
    protected readonly processedBytesAnnotations: HorizontalAnnotation[];
    protected readonly healthyTaskCountMetric?: MetricWithAlarmSupport;
    protected readonly unhealthyTaskCountMetric?: MetricWithAlarmSupport;
    protected readonly healthyTaskPercentMetric?: MetricWithAlarmSupport;
    protected readonly runningTaskCountMetric: MetricWithAlarmSupport;
    protected readonly cpuUtilisationMetric: MetricWithAlarmSupport;
    protected readonly memoryUtilisationMetric: MetricWithAlarmSupport;
    protected readonly activeTcpFlowCountMetric?: MetricWithAlarmSupport;
    protected readonly newTcpFlowCountMetric?: MetricWithAlarmSupport;
    protected readonly processedBytesMetric?: MetricWithAlarmSupport;
    private hasLoadBalancer;
    constructor(scope: MonitoringScope, props: CustomFargateServiceMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuWidget(width: number, height: number): GraphWidget;
    protected createMemoryWidget(width: number, height: number): GraphWidget;
    protected createTaskHealthWidget(width: number, height: number): GraphWidget;
    protected createTpcFlowsWidget(width: number, height: number): GraphWidget;
}
export {};
