"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateServiceMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const aws_loadbalancing_1 = require("../aws-loadbalancing");
const BaseServiceMetricFactory_1 = require("./BaseServiceMetricFactory");
class FargateServiceMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        this.hasLoadBalancer =
            props.loadBalancer !== undefined && props.targetGroup !== undefined;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.fargateService,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.metricFactory = scope.createMetricFactory();
        this.baseServiceMetricFactory = new BaseServiceMetricFactory_1.BaseServiceMetricFactory(this.metricFactory, { service: props.fargateService });
        if (this.hasLoadBalancer) {
            this.loadBalancerMetricFactory = aws_loadbalancing_1.createLoadBalancerMetricFactory(this.metricFactory, props.loadBalancer, props.targetGroup);
            this.healthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskCount();
            this.unhealthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricUnhealthyTaskCount();
            this.healthyTaskPercentMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskInPercent();
            this.activeTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricActiveConnectionCount();
            this.newTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricNewConnectionCount();
            this.processedBytesMetric =
                this.loadBalancerMetricFactory.metricProcessedBytesMin();
        }
        this.runningTaskCountMetric =
            this.baseServiceMetricFactory.metricRunningTaskCount();
        this.cpuUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterCpuUtilisationInPercent();
        this.memoryUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterMemoryUtilisationInPercent();
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(alarmFactory);
        this.throughputAlarmFactory = new common_1.ThroughputAlarmFactory(alarmFactory);
        this.taskHealthAnnotations = [];
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.cpuUsageAnnotations = [];
        this.memoryUsageAnnotations = [];
        this.processedBytesAnnotations = [];
        if (props.minAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.minAutoScalingTaskCount,
                label: "AutoScaling: Min",
                color: common_1.NeutralColor,
            });
        }
        if (props.maxAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.maxAutoScalingTaskCount,
                label: "AutoScaling: Max",
                color: common_1.NeutralColor,
            });
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addHealthyTaskCountAlarm) {
                const alarmProps = props.addHealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addUnhealthyTaskCountAlarm) {
                const alarmProps = props.addUnhealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addUnhealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.unhealthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addHealthyTaskPercentAlarm) {
                const alarmProps = props.addHealthyTaskPercentAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskPercentAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskPercentMetric, alarmProps, disambiguator);
                this.addAlarm(createdAlarm);
            }
        }
        for (const disambiguator in props.addRunningTaskCountAlarm) {
            const alarmProps = props.addRunningTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.runningTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUtilisationMetric, alarmProps, disambiguator);
            this.cpuUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMemoryUsageAlarm) {
            const alarmProps = props.addMemoryUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(this.memoryUtilisationMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addMinProcessedBytesAlarm) {
                const alarmProps = props.addMinProcessedBytesAlarm[disambiguator];
                const createdAlarm = this.throughputAlarmFactory.addMinProcessedBytesAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.processedBytesMetric, alarmProps, disambiguator);
                this.processedBytesAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMemoryWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        const baseWidget = [
            this.createTitleWidget(),
            this.createCpuWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMemoryWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
        if (this.hasLoadBalancer) {
            return baseWidget.concat([
                this.createTpcFlowsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createTaskHealthWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            ]);
        }
        else {
            return baseWidget.concat(this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight));
        }
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Fargate Service",
            title: this.title,
        });
    }
    createCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [this.cpuUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.cpuUsageAnnotations,
        });
    }
    createMemoryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [this.memoryUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.memoryUsageAnnotations,
        });
    }
    createTaskHealthWidget(width, height) {
        const left = [this.runningTaskCountMetric];
        if (this.healthyTaskCountMetric) {
            left.push(this.healthyTaskCountMetric);
        }
        if (this.unhealthyTaskCountMetric) {
            left.push(this.unhealthyTaskCountMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: this.hasLoadBalancer ? "Task Health" : "Task Count",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.taskHealthAnnotations,
        });
    }
    createTpcFlowsWidget(width, height) {
        const left = [];
        const right = [];
        if (this.activeTcpFlowCountMetric) {
            left.push(this.activeTcpFlowCountMetric);
        }
        if (this.newTcpFlowCountMetric) {
            left.push(this.newTcpFlowCountMetric);
        }
        if (this.processedBytesMetric) {
            right.push(this.processedBytesMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TCP Flows",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            right,
            rightYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.FargateServiceMonitoring = FargateServiceMonitoring;
_a = JSII_RTTI_SYMBOL_1;
FargateServiceMonitoring[_a] = { fqn: "cdk-monitoring-constructs.FargateServiceMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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