"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQueueProcessingEc2ServiceMonitoring = exports.getQueueProcessingFargateServiceMonitoring = void 0;
const aws_sqs_1 = require("../aws-sqs");
const Ec2ServiceMonitoring_1 = require("./Ec2ServiceMonitoring");
const FargateServiceMonitoring_1 = require("./FargateServiceMonitoring");
function getQueueProcessingFargateServiceMonitoring(facade, props) {
    return [
        new FargateServiceMonitoring_1.FargateServiceMonitoring(facade, {
            ...props,
            fargateService: props.fargateService.service,
            ...props.addServiceAlarms,
        }),
        getCommonQueueProcessingMonitoring(facade, props, props.fargateService.sqsQueue, props.fargateService.deadLetterQueue),
    ];
}
exports.getQueueProcessingFargateServiceMonitoring = getQueueProcessingFargateServiceMonitoring;
function getQueueProcessingEc2ServiceMonitoring(facade, props) {
    return [
        new Ec2ServiceMonitoring_1.Ec2ServiceMonitoring(facade, {
            ...props,
            ec2Service: props.ec2Service.service,
            ...props.addServiceAlarms,
        }),
        getCommonQueueProcessingMonitoring(facade, props, props.ec2Service.sqsQueue, props.ec2Service.deadLetterQueue),
    ];
}
exports.getQueueProcessingEc2ServiceMonitoring = getQueueProcessingEc2ServiceMonitoring;
function getCommonQueueProcessingMonitoring(scope, props, queue, deadLetterQueue) {
    if (deadLetterQueue) {
        return new aws_sqs_1.SqsQueueMonitoringWithDlq(scope, {
            ...props,
            queue,
            deadLetterQueue: deadLetterQueue,
            ...props.addQueueAlarms,
            ...props.addDeadLetterQueueAlarms,
        });
    }
    else {
        return new aws_sqs_1.SqsQueueMonitoring(scope, {
            ...props,
            queue,
            ...props.addDeadLetterQueueAlarms,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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