"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheClusterMetricFactory = exports.ElastiCacheClusterType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/ElastiCache";
var ElastiCacheClusterType;
(function (ElastiCacheClusterType) {
    ElastiCacheClusterType[ElastiCacheClusterType["MEMCACHED"] = 0] = "MEMCACHED";
    ElastiCacheClusterType[ElastiCacheClusterType["REDIS"] = 1] = "REDIS";
})(ElastiCacheClusterType = exports.ElastiCacheClusterType || (exports.ElastiCacheClusterType = {}));
/**
 * @see https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheMetrics.html
 */
class ElastiCacheClusterMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {};
        if (props.clusterId) {
            this.dimensionsMap.CacheClusterId = props.clusterId;
        }
    }
    metricMaxItemCount() {
        return this.metricFactory.createMetric("CurrItems", common_1.MetricStatistic.MAX, "Count", this.dimensionsMap, undefined, Namespace);
    }
    metricEvictions() {
        return this.metricFactory.createMetric("Evictions", common_1.MetricStatistic.SUM, "Evictions", this.dimensionsMap, undefined, Namespace);
    }
    metricAverageFreeableMemoryInBytes() {
        return this.metricFactory.createMetric("FreeableMemory", common_1.MetricStatistic.AVERAGE, "Freeable", this.dimensionsMap, undefined, Namespace);
    }
    metricAverageUnusedMemoryInBytes() {
        return this.metricFactory.createMetric("UnusedMemory", common_1.MetricStatistic.AVERAGE, "Unused", this.dimensionsMap, undefined, Namespace);
    }
    metricAverageCachedItemsSizeInBytes() {
        return this.metricFactory.createMetric("BytesUsedForCacheItems", common_1.MetricStatistic.AVERAGE, "Items", this.dimensionsMap, undefined, Namespace);
    }
    metricAverageSwapUsageInBytes() {
        return this.metricFactory.createMetric("SwapUsage", common_1.MetricStatistic.AVERAGE, "Swap", this.dimensionsMap, undefined, Namespace);
    }
    metricMaxCpuUtilizationInPercent() {
        return this.metricFactory.createMetric("CPUUtilization", common_1.MetricStatistic.MAX, "Cluster CPU Utilization", this.dimensionsMap, undefined, Namespace);
    }
    metricAverageConnections() {
        return this.metricFactory.createMetric("CurrConnections", common_1.MetricStatistic.AVERAGE, "Current", this.dimensionsMap, undefined, Namespace);
    }
    metricNetworkBytesIn() {
        return this.metricFactory.createMetric("NetworkBytesIn", common_1.MetricStatistic.SUM, "Bytes In", this.dimensionsMap, undefined, Namespace);
    }
    metricNetworkBytesOut() {
        return this.metricFactory.createMetric("NetworkBytesOut", common_1.MetricStatistic.SUM, "Bytes Out", this.dimensionsMap, undefined, Namespace);
    }
}
exports.ElastiCacheClusterMetricFactory = ElastiCacheClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ElastiCacheClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ElastiCacheClusterMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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