import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, ElastiCacheAlarmFactory, MaxItemsCountThreshold, MaxUsedSwapMemoryThreshold, MetricWithAlarmSupport, MinFreeableMemoryThreshold, Monitoring, MonitoringScope, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { ElastiCacheClusterMetricFactoryProps, ElastiCacheClusterType } from "./ElastiCacheClusterMetricFactory";
export interface ElastiCacheClusterMonitoringOptions extends BaseMonitoringProps {
    /**
     * Cluster type (needed, since each type has their own specific metrics)
     */
    readonly clusterType: ElastiCacheClusterType;
    /**
     * Add CPU usage alarm
     */
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
    /**
     * Add alarm on total number of items
     */
    readonly addMaxItemsCountAlarm?: Record<string, MaxItemsCountThreshold>;
    /**
     * Add alarm on number of evicted items
     */
    readonly addMaxEvictedItemsCountAlarm?: Record<string, MaxItemsCountThreshold>;
    /**
     * Add alarm on amount of freeable memory
     */
    readonly addMinFreeableMemoryAlarm?: Record<string, MinFreeableMemoryThreshold>;
    /**
     * Add alarm on amount of used swap memory
     */
    readonly addMaxUsedSwapMemoryAlarm?: Record<string, MaxUsedSwapMemoryThreshold>;
}
export interface ElastiCacheClusterMonitoringProps extends ElastiCacheClusterMetricFactoryProps, ElastiCacheClusterMonitoringOptions {
}
export declare class ElastiCacheClusterMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly clusterUrl?: string;
    protected readonly connectionsMetric: MetricWithAlarmSupport;
    protected readonly cpuUsageMetric: MetricWithAlarmSupport;
    protected readonly freeableMemoryMetric: MetricWithAlarmSupport;
    protected readonly unusedMemoryMetric: MetricWithAlarmSupport;
    protected readonly swapMemoryMetric: MetricWithAlarmSupport;
    protected readonly itemsMemoryMetric: MetricWithAlarmSupport;
    protected readonly itemsCountMetrics: MetricWithAlarmSupport;
    protected readonly itemsEvictedMetrics: MetricWithAlarmSupport;
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly elastiCacheAlarmFactory: ElastiCacheAlarmFactory;
    protected readonly cpuUsageAnnotations: HorizontalAnnotation[];
    protected readonly itemsCountAnnotations: HorizontalAnnotation[];
    protected readonly evictedItemsCountAnnotations: HorizontalAnnotation[];
    protected readonly memoryUsageAnnotations: HorizontalAnnotation[];
    constructor(scope: MonitoringScope, props: ElastiCacheClusterMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuUsageWidget(width: number, height: number): GraphWidget;
    protected createMemoryUsageWidget(width: number, height: number): GraphWidget;
    protected createItemCountWidget(width: number, height: number): GraphWidget;
    protected createConnectionsWidget(width: number, height: number): GraphWidget;
}
