"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheClusterMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const ElastiCacheClusterMetricFactory_1 = require("./ElastiCacheClusterMetricFactory");
class ElastiCacheClusterMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b, _c;
        super(scope, props);
        const clusterType = common_1.capitalizeFirstLetterOnly(ElastiCacheClusterMetricFactory_1.ElastiCacheClusterType[props.clusterType]);
        const fallbackConstructName = [clusterType, (_b = props.clusterId) !== null && _b !== void 0 ? _b : "ALL"].join("-");
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        if (props.clusterId) {
            this.clusterUrl = scope
                .createAwsConsoleUrlFactory()
                .getElastiCacheClusterUrl(props.clusterId, props.clusterType);
        }
        const metricFactory = new ElastiCacheClusterMetricFactory_1.ElastiCacheClusterMetricFactory(scope.createMetricFactory(), props);
        this.connectionsMetric = metricFactory.metricAverageConnections();
        this.cpuUsageMetric = metricFactory.metricMaxCpuUtilizationInPercent();
        this.freeableMemoryMetric =
            metricFactory.metricAverageFreeableMemoryInBytes();
        this.unusedMemoryMetric = metricFactory.metricAverageUnusedMemoryInBytes();
        this.swapMemoryMetric = metricFactory.metricAverageSwapUsageInBytes();
        this.itemsMemoryMetric =
            metricFactory.metricAverageCachedItemsSizeInBytes();
        this.itemsCountMetrics = metricFactory.metricMaxItemCount();
        this.itemsEvictedMetrics = metricFactory.metricEvictions();
        this.cpuUsageAnnotations = [];
        this.itemsCountAnnotations = [];
        this.evictedItemsCountAnnotations = [];
        this.memoryUsageAnnotations = [];
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.elastiCacheAlarmFactory = new common_1.ElastiCacheAlarmFactory(alarmFactory);
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUsageMetric, alarmProps, disambiguator);
            this.cpuUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxItemsCountAlarm) {
            const alarmProps = props.addMaxItemsCountAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxItemsCountAlarm(this.itemsCountMetrics, alarmProps, disambiguator);
            this.itemsCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxEvictedItemsCountAlarm) {
            const alarmProps = props.addMaxEvictedItemsCountAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxEvictedItemsCountAlarm(this.itemsEvictedMetrics, alarmProps, disambiguator);
            this.evictedItemsCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinFreeableMemoryAlarm) {
            const alarmProps = props.addMinFreeableMemoryAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMinFreeableMemoryAlarm(this.freeableMemoryMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxUsedSwapMemoryAlarm) {
            const alarmProps = props.addMaxUsedSwapMemoryAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxUsedSwapMemoryAlarm(this.swapMemoryMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_c = props.useCreatedAlarms) === null || _c === void 0 ? void 0 : _c.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuUsageWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMemoryUsageWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createItemCountWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createCpuUsageWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createMemoryUsageWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createConnectionsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createItemCountWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "ElastiCache Cluster",
            title: this.title,
            goToLinkUrl: this.clusterUrl,
        });
    }
    createCpuUsageWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [this.cpuUsageMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.cpuUsageAnnotations,
        });
    }
    createMemoryUsageWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [
                this.freeableMemoryMetric,
                this.unusedMemoryMetric,
                this.swapMemoryMetric,
            ],
            leftYAxis: common_1.SizeAxisBytesFromZero,
            leftAnnotations: this.memoryUsageAnnotations,
        });
    }
    createItemCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Items",
            left: [this.itemsCountMetrics],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.itemsCountAnnotations,
            right: [this.itemsEvictedMetrics],
            rightYAxis: common_1.CountAxisFromZero,
            rightAnnotations: this.evictedItemsCountAnnotations,
        });
    }
    createConnectionsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Connections",
            left: [this.connectionsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.ElastiCacheClusterMonitoring = ElastiCacheClusterMonitoring;
_a = JSII_RTTI_SYMBOL_1;
ElastiCacheClusterMonitoring[_a] = { fqn: "cdk-monitoring-constructs.ElastiCacheClusterMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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