"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueJobMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const GlueNamespace = "Glue";
class GlueJobMetricFactory {
    constructor(metricFactory, props) {
        var _b;
        this.metricFactory = metricFactory;
        this.rateComputationMethod = (_b = props.rateComputationMethod) !== null && _b !== void 0 ? _b : common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            Type: "gauge",
            JobRunId: "ALL",
            JobName: props.jobName,
        };
    }
    metricTotalReadBytesFromS3() {
        return this.metricFactory.createMetric("glue.ALL.s3.filesystem.read_bytes", common_1.MetricStatistic.SUM, "Read (S3)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricTotalWrittenBytesToS3() {
        return this.metricFactory.createMetric("glue.ALL.s3.filesystem.write_bytes", common_1.MetricStatistic.SUM, "Write (S3)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricAverageExecutorCpuUsagePercentage() {
        return this.metricFactory.createMetric("glue.ALL.system.cpuSystemLoad", common_1.MetricStatistic.AVERAGE, "CPU Usage (executor average)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricAverageExecutorMemoryUsagePercentage() {
        return this.metricFactory.createMetric("glue.ALL.jvm.heap.usage", common_1.MetricStatistic.AVERAGE, "JVM Heap usage (executor average)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricActiveExecutorsAverage() {
        return this.metricFactory.createMetric("glue.driver.ExecutorAllocationManager.executors.numberAllExecutors", common_1.MetricStatistic.AVERAGE, "Active Executors", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricCompletedStagesSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numCompletedStages", common_1.MetricStatistic.SUM, "Completed Stages", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricCompletedTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numCompletedTasks", common_1.MetricStatistic.SUM, "Completed Tasks", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricFailedTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numFailedTasks", common_1.MetricStatistic.SUM, "Failed Tasks", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricFailedTasksRate() {
        return this.metricFactory.toRate(this.metricFailedTasksSum(), this.rateComputationMethod, true, "killed", false);
    }
    metricKilledTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numKilledTasks", common_1.MetricStatistic.SUM, "Killed Tasks", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricKilledTasksRate() {
        return this.metricFactory.toRate(this.metricKilledTasksSum(), this.rateComputationMethod, true, "killed", false);
    }
    metricMaximumNeededExecutors() {
        return this.metricFactory.createMetric("glue.driver.ExecutorAllocationManager.executors.numberMaxNeededExecutors", common_1.MetricStatistic.MAX, "Maximum Needed Executors", this.dimensionsMap, undefined, GlueNamespace);
    }
}
exports.GlueJobMetricFactory = GlueJobMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
GlueJobMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.GlueJobMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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