import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { AlarmFactory, BaseMonitoringProps, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { GlueJobMetricFactoryProps } from "./GlueJobMetricFactory";
export interface GlueJobMonitoringOptions extends GlueJobMetricFactoryProps, BaseMonitoringProps {
    readonly addFailedTaskCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedTaskRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addKilledTaskCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addKilledTaskRateAlarm?: Record<string, ErrorRateThreshold>;
}
export interface GlueJobMonitoringProps extends GlueJobMonitoringOptions {
}
export declare class GlueJobMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly alarmFactory: AlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly bytesReadFromS3Metric: MetricWithAlarmSupport;
    protected readonly bytesWrittenToS3Metric: MetricWithAlarmSupport;
    protected readonly cpuUsageMetric: MetricWithAlarmSupport;
    protected readonly heapMemoryUsageMetric: MetricWithAlarmSupport;
    protected readonly activeExecutorsMetric: MetricWithAlarmSupport;
    protected readonly completedStagesMetric: MetricWithAlarmSupport;
    protected readonly neededExecutorsMetric: MetricWithAlarmSupport;
    protected readonly failedTaskCountMetric: MetricWithAlarmSupport;
    protected readonly failedTaskRateMetric: MetricWithAlarmSupport;
    protected readonly killedTaskCountMetric: MetricWithAlarmSupport;
    protected readonly killedTaskRateMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: GlueJobMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createJobExecutionWidget(width: number, height: number): GraphWidget;
    protected createDataMovementWidget(width: number, height: number): GraphWidget;
    protected createUtilizationWidget(width: number, height: number): GraphWidget;
    protected createErrorCountWidget(width: number, height: number): GraphWidget;
    protected createErrorRateWidget(width: number, height: number): GraphWidget;
}
