"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataStreamMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const DataStreamNamespace = "AWS/Kinesis";
/**
 * @see https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html
 */
class KinesisDataStreamMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            StreamName: props.streamName,
        };
    }
    metricGetRecordsSumBytes() {
        return this.metricFactory.createMetric("GetRecords.Bytes", common_1.MetricStatistic.SUM, "GetRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricGetRecordsIteratorAgeMaxMs() {
        return this.metricFactory.createMetric("GetRecords.IteratorAgeMilliseconds", common_1.MetricStatistic.MAX, "Iterator Age", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricGetRecordsLatencyAverageMs() {
        return this.metricFactory.createMetric("GetRecords.Latency", common_1.MetricStatistic.AVERAGE, "GetRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricGetRecordsSumCount() {
        return this.metricFactory.createMetric("GetRecords.Records", common_1.MetricStatistic.SUM, "GetRecords.Records", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricGetRecordsSuccessCount() {
        return this.metricFactory.createMetric("GetRecords.Success", common_1.MetricStatistic.SUM, "GetRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricIncomingDataSumBytes() {
        return this.metricFactory.createMetric("IncomingBytes", common_1.MetricStatistic.SUM, "Incoming Bytes", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricIncomingDataSumCount() {
        return this.metricFactory.createMetric("IncomingRecords", common_1.MetricStatistic.SUM, "Incoming Records", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordSumBytes() {
        return this.metricFactory.createMetric("PutRecord.Bytes", common_1.MetricStatistic.SUM, "PutRecord", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordLatencyAverageMs() {
        return this.metricFactory.createMetric("PutRecord.Latency", common_1.MetricStatistic.AVERAGE, "PutRecord", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordSuccessCount() {
        return this.metricFactory.createMetric("PutRecord.Success", common_1.MetricStatistic.SUM, "PutRecord", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsSumBytes() {
        return this.metricFactory.createMetric("PutRecords.Bytes", common_1.MetricStatistic.SUM, "PutRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsLatencyAverageMs() {
        return this.metricFactory.createMetric("PutRecords.Latency", common_1.MetricStatistic.AVERAGE, "PutRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsSuccessCount() {
        return this.metricFactory.createMetric("PutRecords.Success", common_1.MetricStatistic.SUM, "PutRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsSuccessfulRecordsCount() {
        return this.metricFactory.createMetric("PutRecords.SuccessfulRecords", common_1.MetricStatistic.SUM, "PutRecords.SuccessfulRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsTotalRecordsCount() {
        return this.metricFactory.createMetric("PutRecords.TotalRecords", common_1.MetricStatistic.SUM, "PutRecords.TotalRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsFailedRecordsCount() {
        return this.metricFactory.createMetric("PutRecords.FailedRecords", common_1.MetricStatistic.SUM, "PutRecords.FailedRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricPutRecordsThrottledRecordsCount() {
        return this.metricFactory.createMetric("PutRecords.ThrottledRecords", common_1.MetricStatistic.SUM, "PutRecords.ThrottledRecords", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricReadProvisionedThroughputExceededPercent() {
        return this.metricFactory.createMetric("ReadProvisionedThroughputExceeded", common_1.MetricStatistic.AVERAGE, "Read", this.dimensionsMap, undefined, DataStreamNamespace);
    }
    metricWriteProvisionedThroughputExceededPercent() {
        return this.metricFactory.createMetric("WriteProvisionedThroughputExceeded", common_1.MetricStatistic.AVERAGE, "Write", this.dimensionsMap, undefined, DataStreamNamespace);
    }
}
exports.KinesisDataStreamMetricFactory = KinesisDataStreamMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataStreamMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.KinesisDataStreamMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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