import { GraphWidget, HorizontalAnnotation, IWidget, Row } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, KinesisAlarmFactory, MaxIteratorAgeThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, RecordsFailedThreshold, RecordsThrottledThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { KinesisDataStreamMetricFactoryProps } from "./KinesisDataStreamMetricFactory";
export interface KinesisDataStreamMonitoringOptions extends BaseMonitoringProps {
    readonly addIteratorMaxAgeAlarm?: Record<string, MaxIteratorAgeThreshold>;
    readonly addPutRecordsThrottledAlarm?: Record<string, RecordsThrottledThreshold>;
    readonly addPutRecordsFailedAlarm?: Record<string, RecordsFailedThreshold>;
    readonly addThrottledRecordsAlarm?: Record<string, RecordsThrottledThreshold>;
    readonly addReadProvisionedThroughputExceededAlarm?: Record<string, RecordsThrottledThreshold>;
    readonly addWriteProvisionedThroughputExceededAlarm?: Record<string, RecordsThrottledThreshold>;
}
export interface KinesisDataStreamMonitoringProps extends KinesisDataStreamMetricFactoryProps, KinesisDataStreamMonitoringOptions {
}
export declare class KinesisDataStreamMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly streamUrl?: string;
    protected readonly kinesisAlarmFactory: KinesisAlarmFactory;
    protected readonly ageAnnotations: HorizontalAnnotation[];
    protected readonly provisionedCapacityAnnotations: HorizontalAnnotation[];
    protected readonly recordCountAnnotations: HorizontalAnnotation[];
    protected readonly metricGetRecordSumBytes: MetricWithAlarmSupport;
    protected readonly metricGetRecordsIteratorAge: MetricWithAlarmSupport;
    protected readonly metricGetRecordsLatencyAverage: MetricWithAlarmSupport;
    protected readonly metricGetRecordsSumCount: MetricWithAlarmSupport;
    protected readonly metricGetRecordsSuccessCount: MetricWithAlarmSupport;
    protected readonly incomingDataSumBytesMetric: MetricWithAlarmSupport;
    protected readonly incomingDataSumCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordSumBytesMetric: MetricWithAlarmSupport;
    protected readonly putRecordLatencyAverageMetric: MetricWithAlarmSupport;
    protected readonly putRecordSuccessCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordsSumBytesMetric: MetricWithAlarmSupport;
    protected readonly putRecordsLatencyAverageMetric: MetricWithAlarmSupport;
    protected readonly putRecordsSuccessCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordsTotalRecordsCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordsSuccessfulRecordsCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordsFailedRecordsCountMetric: MetricWithAlarmSupport;
    protected readonly putRecordsThrottledRecordsCountMetric: MetricWithAlarmSupport;
    protected readonly readProvisionedThroughputExceededMetric: MetricWithAlarmSupport;
    protected readonly writeProvisionedThroughputExceededMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: KinesisDataStreamMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    private createFirstAdditionalRow;
    protected createSecondAdditionalRow(): Row;
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createIncomingDataWidget(width: number, height: number): GraphWidget;
    protected createIteratorAgeWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createCapacityWidget(width: number, height: number): GraphWidget;
    protected createRecordSizeWidget(width: number, height: number): GraphWidget;
    protected createOperationWidget(width: number, height: number): GraphWidget;
    protected createRecordNumberWidget(width: number, height: number): GraphWidget;
}
