"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataStreamMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const KinesisDataStreamMetricFactory_1 = require("./KinesisDataStreamMetricFactory");
class KinesisDataStreamMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.streamName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.streamUrl = scope
            .createAwsConsoleUrlFactory()
            .getKinesisDataStreamUrl(props.streamName);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.kinesisAlarmFactory = new common_1.KinesisAlarmFactory(alarmFactory);
        this.provisionedCapacityAnnotations = [];
        this.ageAnnotations = [];
        this.recordCountAnnotations = [];
        const metricFactory = new KinesisDataStreamMetricFactory_1.KinesisDataStreamMetricFactory(scope.createMetricFactory(), props);
        this.metricGetRecordSumBytes = metricFactory.metricGetRecordsSumBytes();
        this.metricGetRecordsIteratorAge =
            metricFactory.metricGetRecordsIteratorAgeMaxMs();
        this.metricGetRecordsLatencyAverage =
            metricFactory.metricGetRecordsLatencyAverageMs();
        this.metricGetRecordsSumCount = metricFactory.metricGetRecordsSumCount();
        this.metricGetRecordsSuccessCount =
            metricFactory.metricGetRecordsSuccessCount();
        this.incomingDataSumBytesMetric =
            metricFactory.metricIncomingDataSumBytes();
        this.incomingDataSumCountMetric =
            metricFactory.metricIncomingDataSumCount();
        this.putRecordSumBytesMetric = metricFactory.metricPutRecordSumBytes();
        this.putRecordLatencyAverageMetric =
            metricFactory.metricPutRecordLatencyAverageMs();
        this.putRecordSuccessCountMetric =
            metricFactory.metricPutRecordSuccessCount();
        this.putRecordsSumBytesMetric = metricFactory.metricPutRecordsSumBytes();
        this.putRecordsLatencyAverageMetric =
            metricFactory.metricPutRecordsLatencyAverageMs();
        this.putRecordsSuccessCountMetric =
            metricFactory.metricPutRecordsSuccessCount();
        this.putRecordsTotalRecordsCountMetric =
            metricFactory.metricPutRecordsTotalRecordsCount();
        this.putRecordsSuccessfulRecordsCountMetric =
            metricFactory.metricPutRecordsSuccessfulRecordsCount();
        this.putRecordsThrottledRecordsCountMetric =
            metricFactory.metricPutRecordsThrottledRecordsCount();
        this.putRecordsFailedRecordsCountMetric =
            metricFactory.metricPutRecordsFailedRecordsCount();
        this.readProvisionedThroughputExceededMetric =
            metricFactory.metricReadProvisionedThroughputExceededPercent();
        this.writeProvisionedThroughputExceededMetric =
            metricFactory.metricWriteProvisionedThroughputExceededPercent();
        for (const disambiguator in props.addIteratorMaxAgeAlarm) {
            const alarmProps = props.addIteratorMaxAgeAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addIteratorMaxAgeAlarm(this.metricGetRecordsIteratorAge, alarmProps, disambiguator);
            this.ageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addPutRecordsThrottledAlarm) {
            const alarmProps = props.addPutRecordsThrottledAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsThrottledAlarm(this.putRecordsThrottledRecordsCountMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addPutRecordsFailedAlarm) {
            const alarmProps = props.addPutRecordsFailedAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsFailedAlarm(this.putRecordsFailedRecordsCountMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addReadProvisionedThroughputExceededAlarm) {
            const alarmProps = props.addReadProvisionedThroughputExceededAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addProvisionedReadThroughputExceededAlarm(this.readProvisionedThroughputExceededMetric, alarmProps, disambiguator);
            this.provisionedCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addWriteProvisionedThroughputExceededAlarm) {
            const alarmProps = props.addWriteProvisionedThroughputExceededAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addProvisionedWriteThroughputExceededAlarm(this.writeProvisionedThroughputExceededMetric, alarmProps, disambiguator);
            this.provisionedCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createIncomingDataWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createIteratorAgeWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createCapacityWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight)),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createIncomingDataWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createIteratorAgeWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createCapacityWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight)),
            this.createFirstAdditionalRow(),
            this.createSecondAdditionalRow(),
        ];
    }
    createFirstAdditionalRow() {
        return new aws_cloudwatch_1.Row(this.createRecordSizeWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight), this.createOperationWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight));
    }
    createSecondAdditionalRow() {
        return new aws_cloudwatch_1.Row(this.createRecordNumberWidget(common_1.FullWidth, common_1.DefaultGraphWidgetHeight));
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Kinesis Data Stream",
            title: this.title,
            goToLinkUrl: this.streamUrl,
        });
    }
    createIncomingDataWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Incoming",
            left: [this.incomingDataSumCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createIteratorAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Iterator",
            left: [this.metricGetRecordsIteratorAge],
            leftAnnotations: this.ageAnnotations,
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency (Average)",
            left: [
                this.metricGetRecordsLatencyAverage,
                this.putRecordLatencyAverageMetric,
                this.putRecordsLatencyAverageMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Provisioned Capacity Exceeded",
            left: [
                this.readProvisionedThroughputExceededMetric,
                this.writeProvisionedThroughputExceededMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.provisionedCapacityAnnotations,
        });
    }
    createRecordSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Bytes",
            left: [
                this.metricGetRecordSumBytes,
                this.putRecordSumBytesMetric,
                this.putRecordsSumBytesMetric,
            ],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createOperationWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Successful Operations",
            left: [
                this.metricGetRecordsSuccessCount,
                this.putRecordSuccessCountMetric,
                this.putRecordsSuccessCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createRecordNumberWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Records",
            left: [
                this.metricGetRecordsSumCount,
                this.putRecordsTotalRecordsCountMetric,
                this.putRecordsSuccessfulRecordsCountMetric,
                this.putRecordsFailedRecordsCountMetric,
                this.putRecordsThrottledRecordsCountMetric,
            ],
            leftAnnotations: this.recordCountAnnotations,
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.KinesisDataStreamMonitoring = KinesisDataStreamMonitoring;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataStreamMonitoring[_a] = { fqn: "cdk-monitoring-constructs.KinesisDataStreamMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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