import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, KinesisAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope, RecordsThrottledThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { KinesisFirehoseMetricFactoryProps } from "./KinesisFirehoseMetricFactory";
export interface KinesisFirehoseMonitoringOptions extends BaseMonitoringProps {
    readonly addRecordsThrottledAlarm?: Record<string, RecordsThrottledThreshold>;
}
export interface KinesisFirehoseMonitoringProps extends KinesisFirehoseMetricFactoryProps, KinesisFirehoseMonitoringOptions {
}
export declare class KinesisFirehoseMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly streamUrl?: string;
    protected readonly kinesisAlarmFactory: KinesisAlarmFactory;
    protected readonly recordCountAnnotations: HorizontalAnnotation[];
    protected readonly incomingBytesMetric: MetricWithAlarmSupport;
    protected readonly incomingRecordsMetric: MetricWithAlarmSupport;
    protected readonly throttledRecordsMetric: MetricWithAlarmSupport;
    protected readonly successfulConversionMetric: MetricWithAlarmSupport;
    protected readonly failedConversionMetric: MetricWithAlarmSupport;
    protected readonly putRecordLatency: MetricWithAlarmSupport;
    protected readonly putRecordBatchLatency: MetricWithAlarmSupport;
    protected readonly incomingBytesToLimitRate: MetricWithAlarmSupport;
    protected readonly incomingRecordsToLimitRate: MetricWithAlarmSupport;
    protected readonly incomingPutRequestsToLimitRate: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: KinesisFirehoseMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createIncomingRecordWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createConversionWidget(width: number, height: number): GraphWidget;
    protected createLimitWidget(width: number, height: number): GraphWidget;
}
