"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const KinesisFirehoseMetricFactory_1 = require("./KinesisFirehoseMetricFactory");
class KinesisFirehoseMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.deliveryStreamName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.streamUrl = scope
            .createAwsConsoleUrlFactory()
            .getKinesisFirehoseDeliveryStreamUrl(props.deliveryStreamName);
        const metricFactory = new KinesisFirehoseMetricFactory_1.KinesisFirehoseMetricFactory(scope.createMetricFactory(), props);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.kinesisAlarmFactory = new common_1.KinesisAlarmFactory(alarmFactory);
        this.recordCountAnnotations = [];
        this.incomingBytesMetric = metricFactory.metricIncomingBytes();
        this.incomingRecordsMetric = metricFactory.metricIncomingRecordCount();
        this.throttledRecordsMetric = metricFactory.metricThrottledRecordCount();
        this.successfulConversionMetric =
            metricFactory.metricSuccessfulConversionCount();
        this.failedConversionMetric = metricFactory.metricFailedConversionCount();
        this.putRecordLatency = metricFactory.metricPutRecordLatencyP90InMillis();
        this.putRecordBatchLatency =
            metricFactory.metricPutRecordBatchLatencyP90InMillis();
        this.incomingBytesToLimitRate =
            metricFactory.metricIncomingBytesToLimitRate();
        this.incomingRecordsToLimitRate =
            metricFactory.metricIncomingRecordsToLimitRate();
        this.incomingPutRequestsToLimitRate =
            metricFactory.metricIncomingPutRequestsToLimitRate();
        for (const disambiguator in props.addRecordsThrottledAlarm) {
            const alarmProps = props.addRecordsThrottledAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsThrottledAlarm(this.throttledRecordsMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createIncomingRecordWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createConversionWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createIncomingRecordWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createConversionWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createLimitWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Firehose Delivery Stream",
            title: this.title,
            goToLinkUrl: this.streamUrl,
        });
    }
    createIncomingRecordWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Records",
            left: [this.incomingRecordsMetric, this.throttledRecordsMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.recordCountAnnotations,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency (P90)",
            left: [this.putRecordLatency, this.putRecordBatchLatency],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createConversionWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Conversions",
            left: [this.successfulConversionMetric, this.failedConversionMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createLimitWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Limits (rate)",
            left: [
                this.incomingBytesToLimitRate.with({ label: "Bytes" }),
                this.incomingRecordsToLimitRate.with({ label: "Records" }),
                this.incomingPutRequestsToLimitRate.with({ label: "PutRequests" }),
            ],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: [{ value: 1, label: "100% usage" }],
        });
    }
}
exports.KinesisFirehoseMonitoring = KinesisFirehoseMonitoring;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseMonitoring[_a] = { fqn: "cdk-monitoring-constructs.KinesisFirehoseMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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