import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, FullRestartCountThreshold, KinesisDataAnalyticsAlarmFactory, MaxDowntimeThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { KinesisDataAnalyticsMetricFactoryProps } from "./KinesisDataAnalyticsMetricFactory";
export interface KinesisDataAnalyticsMonitoringOptions extends BaseMonitoringProps {
    readonly addDowntimeAlarm?: Record<string, MaxDowntimeThreshold>;
    readonly addFullRestartCountAlarm?: Record<string, FullRestartCountThreshold>;
}
export interface KinesisDataAnalyticsMonitoringProps extends KinesisDataAnalyticsMetricFactoryProps, KinesisDataAnalyticsMonitoringOptions {
}
export declare class KinesisDataAnalyticsMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly kinesisDataAnalyticsUrl?: string;
    protected readonly kdaAlarmFactory: KinesisDataAnalyticsAlarmFactory;
    protected readonly downtimeAnnotations: HorizontalAnnotation[];
    protected readonly fullRestartAnnotations: HorizontalAnnotation[];
    protected readonly cpuUtilizationPercentMetric: MetricWithAlarmSupport;
    protected readonly downtimeMsMetric: MetricWithAlarmSupport;
    protected readonly fullRestartsCountMetric: MetricWithAlarmSupport;
    protected readonly heapMemoryUtilizationPercentMetric: MetricWithAlarmSupport;
    protected readonly kpusCountMetric: MetricWithAlarmSupport;
    protected readonly lastCheckpointDurationMsMetric: MetricWithAlarmSupport;
    protected readonly lastCheckpointSizeBytesMetric: MetricWithAlarmSupport;
    protected readonly numberOfFailedCheckpointsCountMetric: MetricWithAlarmSupport;
    protected readonly oldGenerationGCCountMetric: MetricWithAlarmSupport;
    protected readonly oldGenerationGCTimeMsMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: KinesisDataAnalyticsMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createKPUWidget(width: number, height: number): GraphWidget;
    protected createResourceUtilizationWidget(width: number, height: number): GraphWidget;
    protected createDownTimeWidget(width: number, height: number): GraphWidget;
    protected createFullRestartsWidget(width: number, height: number): GraphWidget;
    protected createNumberOfFailedCheckpointsWidget(width: number, height: number): GraphWidget;
    protected createLastCheckpointDurationWidget(width: number, height: number): GraphWidget;
    protected createLastCheckpointSizeWidget(width: number, height: number): GraphWidget;
    protected createGarbageCollectionWidget(width: number, height: number): GraphWidget;
    private createSummaryWidgetRow;
    private createCheckpointAndGcWidgets;
}
