"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionEnhancedMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const LambdaInsightsNamespace = "LambdaInsights";
class LambdaFunctionEnhancedMetricFactory {
    constructor(metricFactory, lambdaFunction) {
        this.metricFactory = metricFactory;
        this.lambdaFunction = lambdaFunction;
    }
    enhancedMetricMaxCpuTotalTime() {
        return this.enhancedMetric("cpu_total_time", common_1.MetricStatistic.MAX, "CPUTotalTime.Max");
    }
    enhancedMetricP90CpuTotalTime() {
        return this.enhancedMetric("cpu_total_time", common_1.MetricStatistic.P90, "CPUTotalTime.P90");
    }
    enhancedMetricAvgCpuTotalTime() {
        return this.enhancedMetric("cpu_total_time", common_1.MetricStatistic.AVERAGE, "CPUTotalTime.Avg");
    }
    enhancedMetricMaxMemoryUtilization() {
        return this.enhancedMetric("memory_utilization", common_1.MetricStatistic.MAX, "MemoryUtilization.Max");
    }
    enhancedMetricP90MemoryUtilization() {
        return this.enhancedMetric("memory_utilization", common_1.MetricStatistic.P90, "MemoryUtilization.P90");
    }
    enhancedMetricAvgMemoryUtilization() {
        return this.enhancedMetric("memory_utilization", common_1.MetricStatistic.AVERAGE, "MemoryUtilization.Avg");
    }
    enhancedMetricFunctionCost() {
        return this.metricFactory.createMetricMath("memory_utilization * duration", {
            memory_utilization: this.enhancedMetricMaxMemoryUtilization(),
            duration: this.enhancedMetricFunctionDuration(),
        }, "Function Cost (avg: ${AVG}, max: ${MAX})");
    }
    enhancedMetricFunctionDuration() {
        return this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.SUM,
        });
    }
    enhancedMetric(metricName, statistic, label, color) {
        const [functionName, functionVersion] = this.lambdaFunction.functionName.split(":");
        return this.metricFactory.createMetric(metricName, statistic, label, {
            function_name: functionName,
            version: functionVersion,
        }, color, LambdaInsightsNamespace);
    }
}
exports.LambdaFunctionEnhancedMetricFactory = LambdaFunctionEnhancedMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionEnhancedMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.LambdaFunctionEnhancedMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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