"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
class LambdaFunctionMetricFactory {
    constructor(metricFactory, props) {
        var _b, _c;
        this.metricFactory = metricFactory;
        this.lambdaFunction = props.lambdaFunction;
        this.fillTpsWithZeroes = (_b = props.fillTpsWithZeroes) !== null && _b !== void 0 ? _b : true;
        this.rateComputationMethod = (_c = props.rateComputationMethod) !== null && _c !== void 0 ? _c : common_1.RateComputationMethod.AVERAGE;
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricInvocations({
            label: "Invocations",
        }));
    }
    metricThrottlesCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricThrottles({
            label: "Throttles",
        }));
    }
    metricThrottlesRate() {
        const metric = this.metricThrottlesCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "throttles");
    }
    metricFaultCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricErrors({
            label: "Faults",
        }));
    }
    metricFaultRate() {
        const metric = this.metricFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricConcurrentExecutions() {
        return this.lambdaFunction.metric("ConcurrentExecutions", {
            statistic: common_1.MetricStatistic.MAX,
            label: "Concurrent",
        });
    }
    metricProvisionedConcurrencySpilloverInvocations() {
        return this.lambdaFunction.metric("ProvisionedConcurrencySpilloverInvocations", {
            statistic: common_1.MetricStatistic.SUM,
            label: "Provisioned Concurrency Spillovers",
        });
    }
    metricProvisionedConcurrencySpilloverRate() {
        const metric = this.metricProvisionedConcurrencySpilloverInvocations();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "pcsi");
    }
    metricMaxIteratorAgeInMillis() {
        return this.lambdaFunction.metric("IteratorAge", {
            statistic: common_1.MetricStatistic.MAX,
            label: "Iterator Age",
        });
    }
}
exports.LambdaFunctionMetricFactory = LambdaFunctionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.LambdaFunctionMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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