import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { AgeAlarmFactory, AlarmFactory, BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, HighTpsThreshold, LatencyAlarmFactory, LatencyThreshold, LowTpsThreshold, MaxAgeThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, RunningTaskCountThreshold, RunningTaskRateThreshold, TaskHealthAlarmFactory, TpsAlarmFactory, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget, MonitoringNamingStrategy } from "../../dashboard";
import { LambdaFunctionEnhancedMetricFactory } from "./LambdaFunctionEnhancedMetricFactory";
import { LambdaFunctionMetricFactory, LambdaFunctionMetricFactoryProps } from "./LambdaFunctionMetricFactory";
export interface LambdaFunctionMonitoringOptions extends BaseMonitoringProps {
    readonly addLatencyP50Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP90Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP99Alarm?: Record<string, LatencyThreshold>;
    readonly addFaultCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFaultRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addLowTpsAlarm?: Record<string, LowTpsThreshold>;
    readonly addHighTpsAlarm?: Record<string, HighTpsThreshold>;
    readonly addThrottlesCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addThrottlesRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addConcurrentExecutionsCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addProvisionedConcurrencySpilloverInvocationsCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addProvisionedConcurrencySpilloverInvocationsRateAlarm?: Record<string, RunningTaskRateThreshold>;
    readonly addMaxIteratorAgeAlarm?: Record<string, MaxAgeThreshold>;
    readonly addEnhancedMonitoringMaxCpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringP90CpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringAvgCpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringMaxMemoryUtilizationAlarm?: Record<string, UsageThreshold>;
    readonly addEnhancedMonitoringP90MemoryUtilizationAlarm?: Record<string, UsageThreshold>;
    readonly addEnhancedMonitoringAvgMemoryUtilizationAlarm?: Record<string, UsageThreshold>;
}
export interface LambdaFunctionMonitoringProps extends LambdaFunctionMetricFactoryProps, LambdaFunctionMonitoringOptions {
}
export declare class LambdaFunctionMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly functionUrl?: string;
    protected readonly namingStrategy: MonitoringNamingStrategy;
    protected readonly metricFactory: LambdaFunctionMetricFactory;
    protected readonly alarmFactory: AlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly latencyAlarmFactory: LatencyAlarmFactory;
    protected readonly tpsAlarmFactory: TpsAlarmFactory;
    protected readonly taskHealthAlarmFactory: TaskHealthAlarmFactory;
    protected readonly ageAlarmFactory: AgeAlarmFactory;
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly latencyAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly invocationCountAnnotations: HorizontalAnnotation[];
    protected readonly invocationRateAnnotations: HorizontalAnnotation[];
    protected readonly tpsAnnotations: HorizontalAnnotation[];
    protected readonly cpuTotalTimeAnnotations: HorizontalAnnotation[];
    protected readonly memoryUsageAnnotations: HorizontalAnnotation[];
    protected readonly tpsMetric: MetricWithAlarmSupport;
    protected readonly p50LatencyMetric: MetricWithAlarmSupport;
    protected readonly p90LatencyMetric: MetricWithAlarmSupport;
    protected readonly p99LatencyMetric: MetricWithAlarmSupport;
    protected readonly faultCountMetric: MetricWithAlarmSupport;
    protected readonly faultRateMetric: MetricWithAlarmSupport;
    protected readonly invocationCountMetric: MetricWithAlarmSupport;
    protected readonly throttlesCountMetric: MetricWithAlarmSupport;
    protected readonly throttlesRateMetric: MetricWithAlarmSupport;
    protected readonly concurrentExecutionsCountMetric: MetricWithAlarmSupport;
    protected readonly provisionedConcurrencySpilloverInvocationsCountMetric: MetricWithAlarmSupport;
    protected readonly provisionedConcurrencySpilloverInvocationsRateMetric: MetricWithAlarmSupport;
    protected readonly maxIteratorAgeMetric: MetricWithAlarmSupport;
    protected readonly lambdaInsightsEnabled: boolean;
    protected readonly enhancedMetricFactory?: LambdaFunctionEnhancedMetricFactory;
    protected readonly enhancedMonitoringMaxCpuTotalTimeMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMonitoringP90CpuTotalTimeMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMonitoringAvgCpuTotalTimeMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMonitoringMaxMemoryUtilizationMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMonitoringP90MemoryUtilizationMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMonitoringAvgMemoryUtilizationMetric?: MetricWithAlarmSupport;
    protected readonly enhancedMetricFunctionCostMetric?: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: LambdaFunctionMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createTpsWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createErrorCountWidget(width: number, height: number): GraphWidget;
    protected createErrorRateWidget(width: number, height: number): GraphWidget;
    protected createRateWidget(width: number, height: number): GraphWidget;
    protected createInvocationWidget(width: number, height: number): GraphWidget;
    protected createLambdaInsightsCpuWidget(width: number, height: number): GraphWidget;
    protected createLambdaInsightsMemoryWidget(width: number, height: number): GraphWidget;
    protected createLambdaInsightsFunctionCostWidget(width: number, height: number): GraphWidget;
    private resolveFunctionName;
}
