"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const LambdaFunctionEnhancedMetricFactory_1 = require("./LambdaFunctionEnhancedMetricFactory");
const LambdaFunctionMetricFactory_1 = require("./LambdaFunctionMetricFactory");
class LambdaFunctionMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b, _c;
        super(scope, props);
        this.namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.lambdaFunction,
            fallbackConstructName: this.resolveFunctionName(props.lambdaFunction),
        });
        this.title = this.namingStrategy.resolveHumanReadableName();
        this.functionUrl = scope
            .createAwsConsoleUrlFactory()
            .getLambdaFunctionUrl(props.lambdaFunction.functionName);
        this.alarmFactory = this.createAlarmFactory(this.namingStrategy.resolveAlarmFriendlyName());
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(this.alarmFactory);
        this.latencyAlarmFactory = new common_1.LatencyAlarmFactory(this.alarmFactory);
        this.tpsAlarmFactory = new common_1.TpsAlarmFactory(this.alarmFactory);
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(this.alarmFactory);
        this.ageAlarmFactory = new common_1.AgeAlarmFactory(this.alarmFactory);
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(this.alarmFactory);
        this.latencyAnnotations = [];
        this.errorCountAnnotations = [];
        this.errorRateAnnotations = [];
        this.invocationCountAnnotations = [];
        this.invocationRateAnnotations = [];
        this.tpsAnnotations = [];
        this.cpuTotalTimeAnnotations = [];
        this.memoryUsageAnnotations = [];
        this.metricFactory = new LambdaFunctionMetricFactory_1.LambdaFunctionMetricFactory(scope.createMetricFactory(), props);
        this.tpsMetric = this.metricFactory.metricTps();
        this.p50LatencyMetric = this.metricFactory.metricLatencyP50InMillis();
        this.p90LatencyMetric = this.metricFactory.metricLatencyP90InMillis();
        this.p99LatencyMetric = this.metricFactory.metricLatencyP99InMillis();
        this.faultCountMetric = this.metricFactory.metricFaultCount();
        this.faultRateMetric = this.metricFactory.metricFaultRate();
        this.invocationCountMetric = this.metricFactory.metricInvocationCount();
        this.throttlesCountMetric = this.metricFactory.metricThrottlesCount();
        this.throttlesRateMetric = this.metricFactory.metricThrottlesRate();
        this.concurrentExecutionsCountMetric =
            this.metricFactory.metricConcurrentExecutions();
        this.provisionedConcurrencySpilloverInvocationsCountMetric =
            this.metricFactory.metricProvisionedConcurrencySpilloverInvocations();
        this.provisionedConcurrencySpilloverInvocationsRateMetric =
            this.metricFactory.metricProvisionedConcurrencySpilloverRate();
        this.maxIteratorAgeMetric =
            this.metricFactory.metricMaxIteratorAgeInMillis();
        this.lambdaInsightsEnabled = (_b = props.lambdaInsightsEnabled) !== null && _b !== void 0 ? _b : false;
        if (props.lambdaInsightsEnabled) {
            this.enhancedMetricFactory = new LambdaFunctionEnhancedMetricFactory_1.LambdaFunctionEnhancedMetricFactory(scope.createMetricFactory(), props.lambdaFunction);
            this.enhancedMonitoringMaxCpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricMaxCpuTotalTime();
            this.enhancedMonitoringP90CpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricP90CpuTotalTime();
            this.enhancedMonitoringAvgCpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricAvgCpuTotalTime();
            this.enhancedMonitoringMaxMemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricMaxMemoryUtilization();
            this.enhancedMonitoringP90MemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricP90MemoryUtilization();
            this.enhancedMonitoringAvgMemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricAvgMemoryUtilization();
            this.enhancedMetricFunctionCostMetric =
                this.enhancedMetricFactory.enhancedMetricFunctionCost();
            for (const disambiguator in props.addEnhancedMonitoringMaxCpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringMaxCpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxCpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.P100, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringP90CpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringP90CpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringP90CpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.P90, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringAvgCpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringAvgCpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringAvgCpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.AVERAGE, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringMaxMemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringMaxMemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxMemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringP90MemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringP90MemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringP90MemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, common_1.UsageType.P90, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringAvgMemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringAvgMemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringAvgMemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, common_1.UsageType.AVERAGE, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
        }
        for (const disambiguator in props.addLatencyP50Alarm) {
            const alarmProps = props.addLatencyP50Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p50LatencyMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLatencyP90Alarm) {
            const alarmProps = props.addLatencyP90Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p90LatencyMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLatencyP99Alarm) {
            const alarmProps = props.addLatencyP99Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p99LatencyMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFaultCountAlarm) {
            const alarmProps = props.addFaultCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.faultCountMetric, common_1.ErrorType.FAULT, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFaultRateAlarm) {
            const alarmProps = props.addFaultRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.faultRateMetric, common_1.ErrorType.FAULT, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLowTpsAlarm) {
            const alarmProps = props.addLowTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMinTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addHighTpsAlarm) {
            const alarmProps = props.addHighTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMaxTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addThrottlesCountAlarm) {
            const alarmProps = props.addThrottlesCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.throttlesCountMetric, common_1.ErrorType.THROTTLED, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addThrottlesRateAlarm) {
            const alarmProps = props.addThrottlesRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.throttlesRateMetric, common_1.ErrorType.THROTTLED, alarmProps, disambiguator);
            this.invocationRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addConcurrentExecutionsCountAlarm) {
            const alarmProps = props.addConcurrentExecutionsCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.concurrentExecutionsCountMetric, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addProvisionedConcurrencySpilloverInvocationsCountAlarm) {
            const alarmProps = props.addProvisionedConcurrencySpilloverInvocationsCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.provisionedConcurrencySpilloverInvocationsCountMetric, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addProvisionedConcurrencySpilloverInvocationsRateAlarm) {
            const alarmProps = props.addProvisionedConcurrencySpilloverInvocationsRateAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskRateAlarm(this.provisionedConcurrencySpilloverInvocationsRateMetric, alarmProps, disambiguator);
            this.invocationRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxIteratorAgeAlarm) {
            const alarmProps = props.addMaxIteratorAgeAlarm[disambiguator];
            const createdAlarm = this.ageAlarmFactory.addIteratorMaxAgeAlarm(this.maxIteratorAgeMetric, alarmProps, disambiguator);
            this.addAlarm(createdAlarm);
        }
        (_c = props.useCreatedAlarms) === null || _c === void 0 ? void 0 : _c.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTpsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createLatencyWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createErrorRateWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        const widgets = [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createTpsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createErrorRateWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createRateWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createInvocationWidget(common_1.TwoThirdsWidth, common_1.DefaultGraphWidgetHeight), this.createErrorCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)),
        ];
        if (this.lambdaInsightsEnabled) {
            widgets.push(new aws_cloudwatch_1.Row(this.createLambdaInsightsCpuWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createLambdaInsightsMemoryWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createLambdaInsightsFunctionCostWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)));
        }
        return widgets;
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Lambda Function",
            title: this.title,
            goToLinkUrl: this.functionUrl,
        });
    }
    createTpsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TPS",
            left: [this.tpsMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.tpsAnnotations,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency",
            left: [
                this.p50LatencyMetric,
                this.p90LatencyMetric,
                this.p99LatencyMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.latencyAnnotations,
        });
    }
    createErrorCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors",
            left: [this.faultCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.errorCountAnnotations,
        });
    }
    createErrorRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors (rate)",
            left: [this.faultRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.errorRateAnnotations,
        });
    }
    createRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Rates",
            left: [
                this.throttlesRateMetric,
                this.provisionedConcurrencySpilloverInvocationsRateMetric,
            ],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.invocationRateAnnotations,
        });
    }
    createInvocationWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Invocations",
            left: [
                this.invocationCountMetric,
                this.throttlesCountMetric,
                this.concurrentExecutionsCountMetric,
                this.provisionedConcurrencySpilloverInvocationsCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.invocationCountAnnotations,
        });
    }
    createLambdaInsightsCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Total Time",
            left: [
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxCpuTotalTimeMetric,
                this.enhancedMonitoringP90CpuTotalTimeMetric,
                this.enhancedMonitoringAvgCpuTotalTimeMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createLambdaInsightsMemoryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxMemoryUtilizationMetric,
                this.enhancedMonitoringP90MemoryUtilizationMetric,
                this.enhancedMonitoringAvgMemoryUtilizationMetric,
            ],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
        });
    }
    createLambdaInsightsFunctionCostWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Function Cost",
            /* eslint-disable @typescript-eslint/no-non-null-assertion */
            left: [this.enhancedMetricFunctionCostMetric],
            /* eslint-enable @typescript-eslint/no-non-null-assertion */
            leftYAxis: common_1.MegabyteMillisecondAxisFromZero,
        });
    }
    resolveFunctionName(lambdaFunction) {
        var _b;
        // try to take the name (if specified) instead of token
        return (_b = lambdaFunction.node.defaultChild) === null || _b === void 0 ? void 0 : _b.functionName;
    }
}
exports.LambdaFunctionMonitoring = LambdaFunctionMonitoring;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionMonitoring[_a] = { fqn: "cdk-monitoring-constructs.LambdaFunctionMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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