import { ApplicationLoadBalancer, ApplicationTargetGroup } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { MetricFactory } from "../../common";
import { ILoadBalancerMetricFactory } from "./LoadBalancerMetricFactory";
/**
 * Props to create ApplicationLoadBalancerMetricFactory.
 */
export interface ApplicationLoadBalancerMetricFactoryProps {
    readonly applicationLoadBalancer: ApplicationLoadBalancer;
    readonly applicationTargetGroup: ApplicationTargetGroup;
}
/**
 * Metric factory to create metrics for application load-balanced service.
 */
export declare class ApplicationLoadBalancerMetricFactory implements ILoadBalancerMetricFactory {
    protected readonly metricFactory: MetricFactory;
    protected readonly applicationLoadBalancer: ApplicationLoadBalancer;
    protected readonly applicationTargetGroup: ApplicationTargetGroup;
    constructor(metricFactory: MetricFactory, props: ApplicationLoadBalancerMetricFactoryProps);
    metricHealthyTaskCount(): import("../../common").MetricWithAlarmSupport;
    metricUnhealthyTaskCount(): import("../../common").MetricWithAlarmSupport;
    metricHealthyTaskInPercent(): import("../../common").MetricWithAlarmSupport;
    metricActiveConnectionCount(): import("../../common").MetricWithAlarmSupport;
    metricNewConnectionCount(): import("../../common").MetricWithAlarmSupport;
    metricProcessedBytesMin(): import("../../common").MetricWithAlarmSupport;
}
