"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLoadBalancerMetricFactory = void 0;
const aws_elasticloadbalancingv2_1 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const ApplicationLoadBalancerMetricFactory_1 = require("./ApplicationLoadBalancerMetricFactory");
const NetworkLoadBalancerMetricFactory_1 = require("./NetworkLoadBalancerMetricFactory");
/**
 * Factory method to create appropriate metric factory based on the load balancer and target group type.
 * @param metricFactory metric factory
 * @param loadBalancer load balancer
 * @param targetGroup target group
 */
function createLoadBalancerMetricFactory(metricFactory, loadBalancer, targetGroup) {
    if (loadBalancer instanceof aws_elasticloadbalancingv2_1.NetworkLoadBalancer &&
        targetGroup instanceof aws_elasticloadbalancingv2_1.NetworkTargetGroup) {
        return new NetworkLoadBalancerMetricFactory_1.NetworkLoadBalancerMetricFactory(metricFactory, {
            networkLoadBalancer: loadBalancer,
            networkTargetGroup: targetGroup,
        });
    }
    else if (loadBalancer instanceof aws_elasticloadbalancingv2_1.ApplicationLoadBalancer &&
        targetGroup instanceof aws_elasticloadbalancingv2_1.ApplicationTargetGroup) {
        return new ApplicationLoadBalancerMetricFactory_1.ApplicationLoadBalancerMetricFactory(metricFactory, {
            applicationLoadBalancer: loadBalancer,
            applicationTargetGroup: targetGroup,
        });
    }
    else {
        throw new Error("Invalid type of load balancer or target group (only ALB and ELB is supported).");
    }
}
exports.createLoadBalancerMetricFactory = createLoadBalancerMetricFactory;
//# sourceMappingURL=data:application/json;base64,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