"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
/**
 * Metric factory to create metrics for network load-balanced service.
 */
class NetworkLoadBalancerMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.networkLoadBalancer = props.networkLoadBalancer;
        this.networkTargetGroup = props.networkTargetGroup;
    }
    metricHealthyTaskCount() {
        return this.metricFactory.adaptMetric(this.networkTargetGroup.metricHealthyHostCount({
            label: "Healthy Tasks",
            color: common_1.HealthyMetricColor,
            statistic: common_1.MetricStatistic.MIN,
        }));
    }
    metricUnhealthyTaskCount() {
        return this.metricFactory.adaptMetric(this.networkTargetGroup.metricUnHealthyHostCount({
            label: "Unhealthy Tasks",
            color: common_1.UnhealthyMetricColor,
            statistic: common_1.MetricStatistic.MAX,
        }));
    }
    metricHealthyTaskInPercent() {
        const healthyTaskCount = this.metricHealthyTaskCount();
        const unhealthyTaskCount = this.metricUnhealthyTaskCount();
        return this.metricFactory.createMetricMath("(healthyTaskCount / (healthyTaskCount + unhealthyTaskCount)) * 100", { healthyTaskCount, unhealthyTaskCount }, "Healthy Task Percent (avg: ${AVG})");
    }
    metricActiveConnectionCount() {
        return this.metricFactory.adaptMetric(this.networkLoadBalancer.metricActiveFlowCount({
            label: "Active",
        }));
    }
    metricNewConnectionCount() {
        return this.metricFactory.adaptMetric(this.networkLoadBalancer.metricNewFlowCount({
            label: "New",
        }));
    }
    metricProcessedBytesMin() {
        return this.metricFactory.adaptMetric(this.networkLoadBalancer.metricProcessedBytes({
            statistic: common_1.MetricStatistic.MIN,
            label: "Processed Bytes (min)",
        }));
    }
}
exports.NetworkLoadBalancerMetricFactory = NetworkLoadBalancerMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.NetworkLoadBalancerMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTmV0d29ya0xvYWRCYWxhbmNlck1ldHJpY0ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJOZXR3b3JrTG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUtBLHlDQUtzQjtBQVd0Qjs7R0FFRztBQUNILE1BQWEsZ0NBQWdDO0lBTzNDLFlBQ0UsYUFBNEIsRUFDNUIsS0FBNEM7UUFFNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbkMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO0lBQ3JELENBQUM7SUFFRCxzQkFBc0I7UUFDcEIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLHNCQUFzQixDQUFDO1lBQzdDLEtBQUssRUFBRSxlQUFlO1lBQ3RCLEtBQUssRUFBRSwyQkFBa0I7WUFDekIsU0FBUyxFQUFFLHdCQUFlLENBQUMsR0FBRztTQUMvQixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCx3QkFBd0I7UUFDdEIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLHdCQUF3QixDQUFDO1lBQy9DLEtBQUssRUFBRSxpQkFBaUI7WUFDeEIsS0FBSyxFQUFFLDZCQUFvQjtZQUMzQixTQUFTLEVBQUUsd0JBQWUsQ0FBQyxHQUFHO1NBQy9CLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELDBCQUEwQjtRQUN4QixNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1FBQ3ZELE1BQU0sa0JBQWtCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixFQUFFLENBQUM7UUFDM0QsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUN4QyxvRUFBb0UsRUFDcEUsRUFBRSxnQkFBZ0IsRUFBRSxrQkFBa0IsRUFBRSxFQUN4QyxvQ0FBb0MsQ0FDckMsQ0FBQztJQUNKLENBQUM7SUFFRCwyQkFBMkI7UUFDekIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLHFCQUFxQixDQUFDO1lBQzdDLEtBQUssRUFBRSxRQUFRO1NBQ2hCLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELHdCQUF3QjtRQUN0QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsa0JBQWtCLENBQUM7WUFDMUMsS0FBSyxFQUFFLEtBQUs7U0FDYixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCx1QkFBdUI7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLG9CQUFvQixDQUFDO1lBQzVDLFNBQVMsRUFBRSx3QkFBZSxDQUFDLEdBQUc7WUFDOUIsS0FBSyxFQUFFLHVCQUF1QjtTQUMvQixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7O0FBckVILDRFQXNFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIE5ldHdvcmtMb2FkQmFsYW5jZXIsXG4gIE5ldHdvcmtUYXJnZXRHcm91cCxcbn0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyXCI7XG5cbmltcG9ydCB7XG4gIEhlYWx0aHlNZXRyaWNDb2xvcixcbiAgTWV0cmljRmFjdG9yeSxcbiAgTWV0cmljU3RhdGlzdGljLFxuICBVbmhlYWx0aHlNZXRyaWNDb2xvcixcbn0gZnJvbSBcIi4uLy4uL2NvbW1vblwiO1xuaW1wb3J0IHsgSUxvYWRCYWxhbmNlck1ldHJpY0ZhY3RvcnkgfSBmcm9tIFwiLi9Mb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5XCI7XG5cbi8qKlxuICogUHJvcHMgdG8gY3JlYXRlIE5ldHdvcmtMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE5ldHdvcmtMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5UHJvcHMge1xuICByZWFkb25seSBuZXR3b3JrTG9hZEJhbGFuY2VyOiBOZXR3b3JrTG9hZEJhbGFuY2VyO1xuICByZWFkb25seSBuZXR3b3JrVGFyZ2V0R3JvdXA6IE5ldHdvcmtUYXJnZXRHcm91cDtcbn1cblxuLyoqXG4gKiBNZXRyaWMgZmFjdG9yeSB0byBjcmVhdGUgbWV0cmljcyBmb3IgbmV0d29yayBsb2FkLWJhbGFuY2VkIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBOZXR3b3JrTG9hZEJhbGFuY2VyTWV0cmljRmFjdG9yeVxuICBpbXBsZW1lbnRzIElMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5XG57XG4gIHByb3RlY3RlZCByZWFkb25seSBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbmV0d29ya0xvYWRCYWxhbmNlcjogTmV0d29ya0xvYWRCYWxhbmNlcjtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG5ldHdvcmtUYXJnZXRHcm91cDogTmV0d29ya1RhcmdldEdyb3VwO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIG1ldHJpY0ZhY3Rvcnk6IE1ldHJpY0ZhY3RvcnksXG4gICAgcHJvcHM6IE5ldHdvcmtMb2FkQmFsYW5jZXJNZXRyaWNGYWN0b3J5UHJvcHNcbiAgKSB7XG4gICAgdGhpcy5tZXRyaWNGYWN0b3J5ID0gbWV0cmljRmFjdG9yeTtcbiAgICB0aGlzLm5ldHdvcmtMb2FkQmFsYW5jZXIgPSBwcm9wcy5uZXR3b3JrTG9hZEJhbGFuY2VyO1xuICAgIHRoaXMubmV0d29ya1RhcmdldEdyb3VwID0gcHJvcHMubmV0d29ya1RhcmdldEdyb3VwO1xuICB9XG5cbiAgbWV0cmljSGVhbHRoeVRhc2tDb3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5uZXR3b3JrVGFyZ2V0R3JvdXAubWV0cmljSGVhbHRoeUhvc3RDb3VudCh7XG4gICAgICAgIGxhYmVsOiBcIkhlYWx0aHkgVGFza3NcIixcbiAgICAgICAgY29sb3I6IEhlYWx0aHlNZXRyaWNDb2xvcixcbiAgICAgICAgc3RhdGlzdGljOiBNZXRyaWNTdGF0aXN0aWMuTUlOLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljVW5oZWFsdGh5VGFza0NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuYWRhcHRNZXRyaWMoXG4gICAgICB0aGlzLm5ldHdvcmtUYXJnZXRHcm91cC5tZXRyaWNVbkhlYWx0aHlIb3N0Q291bnQoe1xuICAgICAgICBsYWJlbDogXCJVbmhlYWx0aHkgVGFza3NcIixcbiAgICAgICAgY29sb3I6IFVuaGVhbHRoeU1ldHJpY0NvbG9yLFxuICAgICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5NQVgsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNIZWFsdGh5VGFza0luUGVyY2VudCgpIHtcbiAgICBjb25zdCBoZWFsdGh5VGFza0NvdW50ID0gdGhpcy5tZXRyaWNIZWFsdGh5VGFza0NvdW50KCk7XG4gICAgY29uc3QgdW5oZWFsdGh5VGFza0NvdW50ID0gdGhpcy5tZXRyaWNVbmhlYWx0aHlUYXNrQ291bnQoKTtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpY01hdGgoXG4gICAgICBcIihoZWFsdGh5VGFza0NvdW50IC8gKGhlYWx0aHlUYXNrQ291bnQgKyB1bmhlYWx0aHlUYXNrQ291bnQpKSAqIDEwMFwiLFxuICAgICAgeyBoZWFsdGh5VGFza0NvdW50LCB1bmhlYWx0aHlUYXNrQ291bnQgfSxcbiAgICAgIFwiSGVhbHRoeSBUYXNrIFBlcmNlbnQgKGF2ZzogJHtBVkd9KVwiXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0FjdGl2ZUNvbm5lY3Rpb25Db3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5uZXR3b3JrTG9hZEJhbGFuY2VyLm1ldHJpY0FjdGl2ZUZsb3dDb3VudCh7XG4gICAgICAgIGxhYmVsOiBcIkFjdGl2ZVwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljTmV3Q29ubmVjdGlvbkNvdW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuYWRhcHRNZXRyaWMoXG4gICAgICB0aGlzLm5ldHdvcmtMb2FkQmFsYW5jZXIubWV0cmljTmV3Rmxvd0NvdW50KHtcbiAgICAgICAgbGFiZWw6IFwiTmV3XCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNQcm9jZXNzZWRCeXRlc01pbigpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5uZXR3b3JrTG9hZEJhbGFuY2VyLm1ldHJpY1Byb2Nlc3NlZEJ5dGVzKHtcbiAgICAgICAgc3RhdGlzdGljOiBNZXRyaWNTdGF0aXN0aWMuTUlOLFxuICAgICAgICBsYWJlbDogXCJQcm9jZXNzZWQgQnl0ZXMgKG1pbilcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxufVxuIl19