"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const NetworkLoadBalancerMetricFactory_1 = require("./NetworkLoadBalancerMetricFactory");
class NetworkLoadBalancerMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const fallbackConstructName = `${props.networkLoadBalancer}-${props.networkTargetGroup}`;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.humanReadableName = namingStrategy.resolveHumanReadableName();
        this.metricFactory = new NetworkLoadBalancerMetricFactory_1.NetworkLoadBalancerMetricFactory(scope.createMetricFactory(), props);
        this.healthyTaskCountMetric = this.metricFactory.metricHealthyTaskCount();
        this.unhealthyTaskCountMetric =
            this.metricFactory.metricUnhealthyTaskCount();
        this.healthyTaskPercentMetric =
            this.metricFactory.metricHealthyTaskInPercent();
        this.activeTcpFlowCountMetric =
            this.metricFactory.metricActiveConnectionCount();
        this.newTcpFlowCountMetric = this.metricFactory.metricNewConnectionCount();
        this.processedBytesMetric = this.metricFactory.metricProcessedBytesMin();
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(alarmFactory);
        this.throughputAlarmFactory = new common_1.ThroughputAlarmFactory(alarmFactory);
        this.taskHealthAnnotations = [];
        this.processedBytesAnnotations = [];
        for (const disambiguator in props.addHealthyTaskCountAlarm) {
            const alarmProps = props.addHealthyTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskCountAlarm(this.healthyTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addUnhealthyTaskCountAlarm) {
            const alarmProps = props.addUnhealthyTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addUnhealthyTaskCountAlarm(this.unhealthyTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addHealthyTaskPercentAlarm) {
            const alarmProps = props.addHealthyTaskPercentAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskPercentAlarm(this.healthyTaskPercentMetric, alarmProps, disambiguator);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinProcessedBytesAlarm) {
            const alarmProps = props.addMinProcessedBytesAlarm[disambiguator];
            const createdAlarm = this.throughputAlarmFactory.addMinProcessedBytesAlarm(this.processedBytesMetric, alarmProps, disambiguator);
            this.processedBytesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTaskHealthWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createTaskHealthWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createTcpFlowsWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
            this.createTaskHealthWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Network Load Balancer",
            title: this.humanReadableName,
        });
    }
    createTaskHealthWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Task Health",
            left: [this.healthyTaskCountMetric, this.unhealthyTaskCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.taskHealthAnnotations,
        });
    }
    createTcpFlowsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TCP Flows",
            left: [this.activeTcpFlowCountMetric, this.newTcpFlowCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            right: [this.processedBytesMetric],
            rightYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.NetworkLoadBalancerMonitoring = NetworkLoadBalancerMonitoring;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerMonitoring[_a] = { fqn: "cdk-monitoring-constructs.NetworkLoadBalancerMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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