"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchClusterMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const OpenSearchBackportedMetrics_1 = require("./OpenSearchBackportedMetrics");
class OpenSearchClusterMetricFactory {
    constructor(metricFactory, props) {
        var _b, _c;
        this.metricFactory = metricFactory;
        this.domainMetrics = new OpenSearchBackportedMetrics_1.OpenSearchBackportedMetrics(props.domain);
        this.fillTpsWithZeroes = (_b = props.fillTpsWithZeroes) !== null && _b !== void 0 ? _b : true;
        this.rateComputationMethod = (_c = props.rateComputationMethod) !== null && _c !== void 0 ? _c : common_1.RateComputationMethod.AVERAGE;
    }
    metricSearchCount() {
        return this.domainMetrics.metric("SearchRate", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
    }
    metricSearchRate() {
        return this.metricFactory.toRate(this.metricSearchCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    /**
     * @deprecated use metricSearchRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricSearchCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricIndexingLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricIndexingLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricIndexingLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricSearchLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricSearchLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricSearchLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricClusterStatusRed() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterStatusRed({
            label: "Red",
        }));
    }
    metricClusterStatusYellow() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterStatusYellow({
            label: "Yellow",
        }));
    }
    metricDiskSpaceUsageInPercent() {
        const used = this.domainMetrics.metric("ClusterUsedSpace", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
        const free = this.domainMetrics.metric("FreeStorageSpace", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
        return this.metricFactory.createMetricMath("100 * (used/(used+free))", { used, free }, "Disk Usage");
    }
    metricCpuUsage() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricCPUUtilization({
            label: "CPU Usage",
        }));
    }
    metricMasterCpuUsage() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricMasterCPUUtilization({
            label: "Master CPU Usage",
        }));
    }
    metricJvmMemoryPressure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricJVMMemoryPressure({
            label: "JVM Memory Pressure",
        }));
    }
    metricMasterJvmMemoryPressure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricMasterJVMMemoryPressure({
            label: "Master JVM Memory Pressure",
        }));
    }
    metricClusterIndexWriteBlocked() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterIndexWriteBlocked({
            label: "Index Writes Blocked",
        }));
    }
    metricNodes() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricNodes({
            label: "Nodes",
        }));
    }
    metricAutomatedSnapshotFailure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricAutomatedSnapshotFailure({
            label: "Automated Snapshot Failures",
        }));
    }
    metricKmsKeyError() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricKMSKeyError({
            label: "KMS Key Error",
        }));
    }
    metricKmsKeyInaccessible() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricKMSKeyInaccessible({
            label: "KMS Key Inaccessible",
        }));
    }
}
exports.OpenSearchClusterMetricFactory = OpenSearchClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
OpenSearchClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.OpenSearchClusterMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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