import { HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, LatencyAlarmFactory, LatencyThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, OpenSearchClusterAlarmFactory, OpenSearchClusterAutomatedSnapshotFailureThreshold, OpenSearchClusterIndexWritesBlockedThreshold, OpenSearchClusterNodesThreshold, OpenSearchClusterStatusCustomization, OpenSearchKmsKeyErrorThreshold, OpenSearchKmsKeyInaccessibleThreshold, UsageAlarmFactory, UsageThreshold } from "../../common";
import { OpenSearchClusterMetricFactoryProps } from "./OpenSearchClusterMetricFactory";
export interface OpenSearchClusterMonitoringOptions extends BaseMonitoringProps {
    readonly addIndexingLatencyP50Alarm?: Record<string, LatencyThreshold>;
    readonly addIndexingLatencyP90Alarm?: Record<string, LatencyThreshold>;
    readonly addIndexingLatencyP99Alarm?: Record<string, LatencyThreshold>;
    readonly addSearchLatencyP50Alarm?: Record<string, LatencyThreshold>;
    readonly addSearchLatencyP90Alarm?: Record<string, LatencyThreshold>;
    readonly addSearchLatencyP99Alarm?: Record<string, LatencyThreshold>;
    readonly addClusterStatusAlarm?: Record<string, OpenSearchClusterStatusCustomization>;
    readonly addDiskSpaceUsageAlarm?: Record<string, UsageThreshold>;
    readonly addCpuSpaceUsageAlarm?: Record<string, UsageThreshold>;
    readonly addMasterCpuSpaceUsageAlarm?: Record<string, UsageThreshold>;
    readonly addJvmMemoryPressureAlarm?: Record<string, UsageThreshold>;
    readonly addMasterJvmMemoryPressureAlarm?: Record<string, UsageThreshold>;
    readonly addClusterIndexWritesBlockedAlarm?: Record<string, OpenSearchClusterIndexWritesBlockedThreshold>;
    readonly addClusterNodeCountAlarm?: Record<string, OpenSearchClusterNodesThreshold>;
    readonly addClusterAutomatedSnapshotFailureAlarm?: Record<string, OpenSearchClusterAutomatedSnapshotFailureThreshold>;
    readonly addKmsKeyErrorAlarm?: Record<string, OpenSearchKmsKeyErrorThreshold>;
    readonly addKmsKeyInaccessibleAlarm?: Record<string, OpenSearchKmsKeyInaccessibleThreshold>;
}
export interface OpenSearchClusterMonitoringProps extends OpenSearchClusterMetricFactoryProps, OpenSearchClusterMonitoringOptions {
}
export declare class OpenSearchClusterMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly url?: string;
    protected readonly indexingLatencyAlarmFactory: LatencyAlarmFactory;
    protected readonly indexingLatencyAnnotations: HorizontalAnnotation[];
    protected readonly searchLatencyAlarmFactory: LatencyAlarmFactory;
    protected readonly searchLatencyAnnotations: HorizontalAnnotation[];
    protected readonly clusterAlarmFactory: OpenSearchClusterAlarmFactory;
    protected readonly clusterAnnotations: HorizontalAnnotation[];
    protected readonly nodeAnnotations: HorizontalAnnotation[];
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly usageAnnotations: HorizontalAnnotation[];
    protected readonly masterUsageAnnotations: HorizontalAnnotation[];
    protected readonly tpsMetric: MetricWithAlarmSupport;
    protected readonly p50IndexingLatencyMetric: MetricWithAlarmSupport;
    protected readonly p90IndexingLatencyMetric: MetricWithAlarmSupport;
    protected readonly p99IndexingLatencyMetric: MetricWithAlarmSupport;
    protected readonly p50SearchLatencyMetric: MetricWithAlarmSupport;
    protected readonly p90SearchLatencyMetric: MetricWithAlarmSupport;
    protected readonly p99SearchLatencyMetric: MetricWithAlarmSupport;
    protected readonly clusterStatusRedMetric: MetricWithAlarmSupport;
    protected readonly clusterStatusYellowMetric: MetricWithAlarmSupport;
    protected readonly diskSpaceUsageMetric: MetricWithAlarmSupport;
    protected readonly cpuUsageMetric: MetricWithAlarmSupport;
    protected readonly masterCpuUsageMetric: MetricWithAlarmSupport;
    protected readonly jvmMemoryPressureMetric: MetricWithAlarmSupport;
    protected readonly masterJvmMemoryPressureMetric: MetricWithAlarmSupport;
    protected readonly indexWriteBlockedMetric: MetricWithAlarmSupport;
    protected readonly nodesMetric: MetricWithAlarmSupport;
    protected readonly automatedSnapshotFailureMetric: MetricWithAlarmSupport;
    protected readonly kmsKeyErrorMetric: MetricWithAlarmSupport;
    protected readonly kmsKeyInaccessibleMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: OpenSearchClusterMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
}
