"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchClusterMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const OpenSearchClusterMetricFactory_1 = require("./OpenSearchClusterMetricFactory");
class OpenSearchClusterMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.domain,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.url = props.domain.domainName
            ? scope
                .createAwsConsoleUrlFactory()
                .getOpenSearchClusterUrl(props.domain.domainName)
            : undefined;
        const alarmPrefix = namingStrategy.resolveAlarmFriendlyName();
        const indexingAlarmPrefix = `${alarmPrefix}-Indexing`;
        const searchAlarmPrefix = `${alarmPrefix}-Search`;
        const clusterAlarmPrefix = `${alarmPrefix}-Cluster`;
        this.indexingLatencyAlarmFactory = new common_1.LatencyAlarmFactory(this.createAlarmFactory(indexingAlarmPrefix));
        this.indexingLatencyAnnotations = [];
        this.searchLatencyAlarmFactory = new common_1.LatencyAlarmFactory(this.createAlarmFactory(searchAlarmPrefix));
        this.searchLatencyAnnotations = [];
        this.clusterAlarmFactory = new common_1.OpenSearchClusterAlarmFactory(this.createAlarmFactory(clusterAlarmPrefix));
        this.clusterAnnotations = [];
        this.nodeAnnotations = [];
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(this.createAlarmFactory(alarmPrefix));
        this.usageAnnotations = [];
        this.masterUsageAnnotations = [];
        const metricFactory = new OpenSearchClusterMetricFactory_1.OpenSearchClusterMetricFactory(scope.createMetricFactory(), props);
        this.tpsMetric = metricFactory.metricTps();
        this.p50IndexingLatencyMetric =
            metricFactory.metricIndexingLatencyP50InMillis();
        this.p90IndexingLatencyMetric =
            metricFactory.metricIndexingLatencyP90InMillis();
        this.p99IndexingLatencyMetric =
            metricFactory.metricIndexingLatencyP99InMillis();
        this.p50SearchLatencyMetric =
            metricFactory.metricSearchLatencyP50InMillis();
        this.p90SearchLatencyMetric =
            metricFactory.metricSearchLatencyP90InMillis();
        this.p99SearchLatencyMetric =
            metricFactory.metricSearchLatencyP99InMillis();
        this.clusterStatusRedMetric = metricFactory.metricClusterStatusRed();
        this.clusterStatusYellowMetric = metricFactory.metricClusterStatusYellow();
        this.diskSpaceUsageMetric = metricFactory.metricDiskSpaceUsageInPercent();
        this.cpuUsageMetric = metricFactory.metricCpuUsage();
        this.masterCpuUsageMetric = metricFactory.metricMasterCpuUsage();
        this.jvmMemoryPressureMetric = metricFactory.metricJvmMemoryPressure();
        this.masterJvmMemoryPressureMetric =
            metricFactory.metricMasterJvmMemoryPressure();
        this.indexWriteBlockedMetric =
            metricFactory.metricClusterIndexWriteBlocked();
        this.nodesMetric = metricFactory.metricNodes();
        this.automatedSnapshotFailureMetric =
            metricFactory.metricAutomatedSnapshotFailure();
        this.kmsKeyErrorMetric = metricFactory.metricKmsKeyError();
        this.kmsKeyInaccessibleMetric = metricFactory.metricKmsKeyInaccessible();
        for (const disambiguator in props.addIndexingLatencyP50Alarm) {
            const alarmProps = props.addIndexingLatencyP50Alarm[disambiguator];
            const createdAlarm = this.indexingLatencyAlarmFactory.addLatencyAlarm(this.p50IndexingLatencyMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.indexingLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addIndexingLatencyP90Alarm) {
            const alarmProps = props.addIndexingLatencyP90Alarm[disambiguator];
            const createdAlarm = this.indexingLatencyAlarmFactory.addLatencyAlarm(this.p90IndexingLatencyMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.indexingLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addIndexingLatencyP99Alarm) {
            const alarmProps = props.addIndexingLatencyP99Alarm[disambiguator];
            const createdAlarm = this.indexingLatencyAlarmFactory.addLatencyAlarm(this.p99IndexingLatencyMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.indexingLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addSearchLatencyP50Alarm) {
            const alarmProps = props.addSearchLatencyP50Alarm[disambiguator];
            const createdAlarm = this.searchLatencyAlarmFactory.addLatencyAlarm(this.p50SearchLatencyMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.searchLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addSearchLatencyP90Alarm) {
            const alarmProps = props.addSearchLatencyP90Alarm[disambiguator];
            const createdAlarm = this.searchLatencyAlarmFactory.addLatencyAlarm(this.p90SearchLatencyMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.searchLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addSearchLatencyP99Alarm) {
            const alarmProps = props.addSearchLatencyP99Alarm[disambiguator];
            const createdAlarm = this.searchLatencyAlarmFactory.addLatencyAlarm(this.p99SearchLatencyMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.searchLatencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addClusterStatusAlarm) {
            const alarmProps = props.addClusterStatusAlarm[disambiguator];
            let createdAlarm;
            switch (alarmProps.status) {
                case common_1.OpenSearchClusterStatus.RED:
                    createdAlarm = this.clusterAlarmFactory.addClusterStatusAlarm(this.clusterStatusRedMetric, alarmProps, disambiguator);
                    break;
                case common_1.OpenSearchClusterStatus.YELLOW:
                    createdAlarm = this.clusterAlarmFactory.addClusterStatusAlarm(this.clusterStatusYellowMetric, alarmProps, disambiguator);
                    break;
                default:
                    throw new Error(`Unknown cluster status: ${alarmProps.status}`);
            }
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDiskSpaceUsageAlarm) {
            const alarmProps = props.addDiskSpaceUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxDiskUsagePercentAlarm(this.diskSpaceUsageMetric, alarmProps, disambiguator);
            this.usageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addCpuSpaceUsageAlarm) {
            const alarmProps = props.addCpuSpaceUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUsageMetric, alarmProps, disambiguator);
            this.usageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMasterCpuSpaceUsageAlarm) {
            const alarmProps = props.addMasterCpuSpaceUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMasterCpuUsagePercentAlarm(this.masterCpuUsageMetric, alarmProps, disambiguator);
            this.masterUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addJvmMemoryPressureAlarm) {
            const alarmProps = props.addJvmMemoryPressureAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(this.jvmMemoryPressureMetric, alarmProps, disambiguator);
            this.usageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMasterJvmMemoryPressureAlarm) {
            const alarmProps = props.addMasterJvmMemoryPressureAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMasterMemoryUsagePercentAlarm(this.masterJvmMemoryPressureMetric, alarmProps, disambiguator);
            this.masterUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addClusterNodeCountAlarm) {
            const alarmProps = props.addClusterNodeCountAlarm[disambiguator];
            const createdAlarm = this.clusterAlarmFactory.addClusterNodeCountAlarm(this.nodesMetric, alarmProps, disambiguator);
            this.nodeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addClusterIndexWritesBlockedAlarm) {
            const alarmProps = props.addClusterIndexWritesBlockedAlarm[disambiguator];
            const createdAlarm = this.clusterAlarmFactory.addClusterIndexWritesBlockedAlarm(this.indexWriteBlockedMetric, alarmProps, disambiguator);
            this.clusterAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addClusterAutomatedSnapshotFailureAlarm) {
            const alarmProps = props.addClusterAutomatedSnapshotFailureAlarm[disambiguator];
            const createdAlarm = this.clusterAlarmFactory.addAutomatedSnapshotFailureAlarm(this.automatedSnapshotFailureMetric, alarmProps, disambiguator);
            this.clusterAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addKmsKeyErrorAlarm) {
            const alarmProps = props.addKmsKeyErrorAlarm[disambiguator];
            const createdAlarm = this.clusterAlarmFactory.addKmsKeyErrorAlarm(this.kmsKeyErrorMetric, alarmProps, disambiguator);
            this.clusterAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addKmsKeyInaccessibleAlarm) {
            const alarmProps = props.addKmsKeyInaccessibleAlarm[disambiguator];
            const createdAlarm = this.clusterAlarmFactory.addKmsKeyInaccessibleAlarm(this.kmsKeyInaccessibleMetric, alarmProps, disambiguator);
            this.clusterAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        // TODO: separate into individual widget methods
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "Elasticsearch Domain",
                title: this.title,
                goToLinkUrl: this.url,
            }),
            // Requests (TPS)
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "TPS",
                left: [this.tpsMetric],
                leftYAxis: common_1.RateAxisFromZero,
            }),
            // Indexing latency
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Indexing Latency",
                left: [
                    this.p50IndexingLatencyMetric,
                    this.p90IndexingLatencyMetric,
                    this.p99IndexingLatencyMetric,
                ],
                leftYAxis: common_1.TimeAxisMillisFromZero,
                leftAnnotations: this.indexingLatencyAnnotations,
            }),
            // Search latency
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Search Latency",
                left: [
                    this.p50SearchLatencyMetric,
                    this.p90SearchLatencyMetric,
                    this.p99SearchLatencyMetric,
                ],
                leftYAxis: common_1.TimeAxisMillisFromZero,
                leftAnnotations: this.searchLatencyAnnotations,
            }),
            // CPU, memory, and disk usage
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "CPU/Memory/Disk Usage",
                left: [
                    this.cpuUsageMetric,
                    this.masterCpuUsageMetric,
                    this.jvmMemoryPressureMetric,
                    this.masterJvmMemoryPressureMetric,
                    this.diskSpaceUsageMetric,
                ],
                leftYAxis: common_1.PercentageAxisFromZeroToHundred,
                leftAnnotations: [
                    ...this.usageAnnotations,
                    ...this.masterUsageAnnotations,
                ],
            }),
        ];
    }
    widgets() {
        // TODO: separate into individual widget methods
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "Elasticsearch Domain",
                title: this.title,
                goToLinkUrl: this.url,
            }),
            new aws_cloudwatch_1.Row(
            // Requests (TPS)
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "TPS",
                left: [this.tpsMetric],
                leftYAxis: common_1.RateAxisFromZero,
            }), 
            // Indexing latency
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Indexing Latency",
                left: [
                    this.p50IndexingLatencyMetric,
                    this.p90IndexingLatencyMetric,
                    this.p99IndexingLatencyMetric,
                ],
                leftAnnotations: this.indexingLatencyAnnotations,
            }), 
            // Search latency
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Search Latency",
                left: [
                    this.p50SearchLatencyMetric,
                    this.p90SearchLatencyMetric,
                    this.p99SearchLatencyMetric,
                ],
                leftAnnotations: this.searchLatencyAnnotations,
            }), 
            // Node count
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Node Count",
                left: [this.nodesMetric],
                leftYAxis: common_1.CountAxisFromZero,
                leftAnnotations: this.nodeAnnotations,
            })),
            new aws_cloudwatch_1.Row(
            // CPU, memory, and disk usage
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.ThirdWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "CPU/Memory/Disk Usage",
                left: [
                    this.cpuUsageMetric,
                    this.jvmMemoryPressureMetric,
                    this.diskSpaceUsageMetric,
                ],
                leftYAxis: common_1.PercentageAxisFromZeroToHundred,
                leftAnnotations: this.usageAnnotations,
            }), 
            // Master CPU and memory
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.ThirdWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Master CPU/Memory Usage",
                left: [this.masterCpuUsageMetric, this.masterJvmMemoryPressureMetric],
                leftYAxis: common_1.PercentageAxisFromZeroToHundred,
                leftAnnotations: this.masterUsageAnnotations,
            }), 
            // Index/Snapshot/KMS Errors
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.ThirdWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Index/Snapshot/KMS Errors",
                left: [
                    this.indexWriteBlockedMetric,
                    this.automatedSnapshotFailureMetric,
                    this.kmsKeyErrorMetric,
                    this.kmsKeyInaccessibleMetric,
                ],
                leftYAxis: common_1.CountAxisFromZero,
                leftAnnotations: this.clusterAnnotations,
            })),
        ];
    }
}
exports.OpenSearchClusterMonitoring = OpenSearchClusterMonitoring;
_a = JSII_RTTI_SYMBOL_1;
OpenSearchClusterMonitoring[_a] = { fqn: "cdk-monitoring-constructs.OpenSearchClusterMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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