import { DimensionsMap } from "aws-cdk-lib/aws-cloudwatch";
import { MetricFactory } from "../../common";
export interface RdsClusterMetricFactoryProps {
    readonly clusterIdentifier: string;
}
export declare class RdsClusterMetricFactory {
    protected readonly metricFactory: MetricFactory;
    protected readonly dimensionsMap: DimensionsMap;
    constructor(metricFactory: MetricFactory, props: RdsClusterMetricFactoryProps);
    metricTotalConnectionCount(): import("../../common").MetricWithAlarmSupport;
    metricFreeStorageInBytes(): import("../../common").MetricWithAlarmSupport;
    metricUsedStorageInBytes(): import("../../common").MetricWithAlarmSupport;
    metricDiskSpaceUsageInPercent(): import("../../common").MetricWithAlarmSupport;
    metricAverageCpuUsageInPercent(): import("../../common").MetricWithAlarmSupport;
    metricSelectLatencyP90InMillis(): import("../../common").MetricWithAlarmSupport;
    metricInsertLatencyP90InMillis(): import("../../common").MetricWithAlarmSupport;
    metricUpdateLatencyP90InMillis(): import("../../common").MetricWithAlarmSupport;
    metricDeleteLatencyP90InMillis(): import("../../common").MetricWithAlarmSupport;
    metricCommitLatencyP90InMillis(): import("../../common").MetricWithAlarmSupport;
    private metric;
}
