"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsClusterMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const RdsNamespace = "AWS/RDS";
class RdsClusterMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            DBClusterIdentifier: props.clusterIdentifier,
        };
    }
    metricTotalConnectionCount() {
        return this.metric("DatabaseConnections", common_1.MetricStatistic.SUM, "Connections");
    }
    metricFreeStorageInBytes() {
        return this.metric("FreeLocalStorage", common_1.MetricStatistic.MIN, "Free");
    }
    metricUsedStorageInBytes() {
        return this.metric("VolumeBytesUsed", common_1.MetricStatistic.MAX, "Used");
    }
    metricDiskSpaceUsageInPercent() {
        const used = this.metricUsedStorageInBytes();
        const free = this.metricFreeStorageInBytes();
        return this.metricFactory.createMetricMath("100 * (used/(used+free))", { used, free }, "Disk Usage");
    }
    metricAverageCpuUsageInPercent() {
        return this.metric("CPUUtilization", common_1.MetricStatistic.AVERAGE, "CPU Usage");
    }
    metricSelectLatencyP90InMillis() {
        return this.metric("SelectLatency", common_1.MetricStatistic.P90, "Select");
    }
    metricInsertLatencyP90InMillis() {
        return this.metric("InsertLatency", common_1.MetricStatistic.P90, "Insert");
    }
    metricUpdateLatencyP90InMillis() {
        return this.metric("UpdateLatency", common_1.MetricStatistic.P90, "Update");
    }
    metricDeleteLatencyP90InMillis() {
        return this.metric("DeleteLatency", common_1.MetricStatistic.P90, "Delete");
    }
    metricCommitLatencyP90InMillis() {
        return this.metric("CommitLatency", common_1.MetricStatistic.P90, "Commit");
    }
    metric(metricName, statistic, label) {
        return this.metricFactory.createMetric(metricName, statistic, label, this.dimensionsMap, undefined, RdsNamespace);
    }
}
exports.RdsClusterMetricFactory = RdsClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
RdsClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.RdsClusterMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUmRzQ2x1c3Rlck1ldHJpY0ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJSZHNDbHVzdGVyTWV0cmljRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUVBLHlDQUE4RDtBQUU5RCxNQUFNLFlBQVksR0FBRyxTQUFTLENBQUM7QUFNL0IsTUFBYSx1QkFBdUI7SUFJbEMsWUFDRSxhQUE0QixFQUM1QixLQUFtQztRQUVuQyxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQztRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHO1lBQ25CLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7U0FDN0MsQ0FBQztJQUNKLENBQUM7SUFFRCwwQkFBMEI7UUFDeEIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUNoQixxQkFBcUIsRUFDckIsd0JBQWUsQ0FBQyxHQUFHLEVBQ25CLGFBQWEsQ0FDZCxDQUFDO0lBQ0osQ0FBQztJQUVELHdCQUF3QjtRQUN0QixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsa0JBQWtCLEVBQUUsd0JBQWUsQ0FBQyxHQUFHLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDdEUsQ0FBQztJQUVELHdCQUF3QjtRQUN0QixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCLEVBQUUsd0JBQWUsQ0FBQyxHQUFHLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUVELDZCQUE2QjtRQUMzQixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztRQUM3QyxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsZ0JBQWdCLENBQ3hDLDBCQUEwQixFQUMxQixFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsRUFDZCxZQUFZLENBQ2IsQ0FBQztJQUNKLENBQUM7SUFFRCw4QkFBOEI7UUFDNUIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGdCQUFnQixFQUFFLHdCQUFlLENBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0lBQzdFLENBQUM7SUFFRCw4QkFBOEI7UUFDNUIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSx3QkFBZSxDQUFDLEdBQUcsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUNyRSxDQUFDO0lBRUQsOEJBQThCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsd0JBQWUsQ0FBQyxHQUFHLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUVELDhCQUE4QjtRQUM1QixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLHdCQUFlLENBQUMsR0FBRyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQ3JFLENBQUM7SUFFRCw4QkFBOEI7UUFDNUIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSx3QkFBZSxDQUFDLEdBQUcsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUNyRSxDQUFDO0lBRUQsOEJBQThCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsd0JBQWUsQ0FBQyxHQUFHLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUVPLE1BQU0sQ0FDWixVQUFrQixFQUNsQixTQUEwQixFQUMxQixLQUFhO1FBRWIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FDcEMsVUFBVSxFQUNWLFNBQVMsRUFDVCxLQUFLLEVBQ0wsSUFBSSxDQUFDLGFBQWEsRUFDbEIsU0FBUyxFQUNULFlBQVksQ0FDYixDQUFDO0lBQ0osQ0FBQzs7QUE3RUgsMERBOEVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGltZW5zaW9uc01hcCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuXG5pbXBvcnQgeyBNZXRyaWNGYWN0b3J5LCBNZXRyaWNTdGF0aXN0aWMgfSBmcm9tIFwiLi4vLi4vY29tbW9uXCI7XG5cbmNvbnN0IFJkc05hbWVzcGFjZSA9IFwiQVdTL1JEU1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFJkc0NsdXN0ZXJNZXRyaWNGYWN0b3J5UHJvcHMge1xuICByZWFkb25seSBjbHVzdGVySWRlbnRpZmllcjogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgUmRzQ2x1c3Rlck1ldHJpY0ZhY3Rvcnkge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbWV0cmljRmFjdG9yeTogTWV0cmljRmFjdG9yeTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGRpbWVuc2lvbnNNYXA6IERpbWVuc2lvbnNNYXA7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgbWV0cmljRmFjdG9yeTogTWV0cmljRmFjdG9yeSxcbiAgICBwcm9wczogUmRzQ2x1c3Rlck1ldHJpY0ZhY3RvcnlQcm9wc1xuICApIHtcbiAgICB0aGlzLm1ldHJpY0ZhY3RvcnkgPSBtZXRyaWNGYWN0b3J5O1xuICAgIHRoaXMuZGltZW5zaW9uc01hcCA9IHtcbiAgICAgIERCQ2x1c3RlcklkZW50aWZpZXI6IHByb3BzLmNsdXN0ZXJJZGVudGlmaWVyLFxuICAgIH07XG4gIH1cblxuICBtZXRyaWNUb3RhbENvbm5lY3Rpb25Db3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoXG4gICAgICBcIkRhdGFiYXNlQ29ubmVjdGlvbnNcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5TVU0sXG4gICAgICBcIkNvbm5lY3Rpb25zXCJcbiAgICApO1xuICB9XG5cbiAgbWV0cmljRnJlZVN0b3JhZ2VJbkJ5dGVzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcIkZyZWVMb2NhbFN0b3JhZ2VcIiwgTWV0cmljU3RhdGlzdGljLk1JTiwgXCJGcmVlXCIpO1xuICB9XG5cbiAgbWV0cmljVXNlZFN0b3JhZ2VJbkJ5dGVzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcIlZvbHVtZUJ5dGVzVXNlZFwiLCBNZXRyaWNTdGF0aXN0aWMuTUFYLCBcIlVzZWRcIik7XG4gIH1cblxuICBtZXRyaWNEaXNrU3BhY2VVc2FnZUluUGVyY2VudCgpIHtcbiAgICBjb25zdCB1c2VkID0gdGhpcy5tZXRyaWNVc2VkU3RvcmFnZUluQnl0ZXMoKTtcbiAgICBjb25zdCBmcmVlID0gdGhpcy5tZXRyaWNGcmVlU3RvcmFnZUluQnl0ZXMoKTtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpY01hdGgoXG4gICAgICBcIjEwMCAqICh1c2VkLyh1c2VkK2ZyZWUpKVwiLFxuICAgICAgeyB1c2VkLCBmcmVlIH0sXG4gICAgICBcIkRpc2sgVXNhZ2VcIlxuICAgICk7XG4gIH1cblxuICBtZXRyaWNBdmVyYWdlQ3B1VXNhZ2VJblBlcmNlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKFwiQ1BVVXRpbGl6YXRpb25cIiwgTWV0cmljU3RhdGlzdGljLkFWRVJBR0UsIFwiQ1BVIFVzYWdlXCIpO1xuICB9XG5cbiAgbWV0cmljU2VsZWN0TGF0ZW5jeVA5MEluTWlsbGlzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcIlNlbGVjdExhdGVuY3lcIiwgTWV0cmljU3RhdGlzdGljLlA5MCwgXCJTZWxlY3RcIik7XG4gIH1cblxuICBtZXRyaWNJbnNlcnRMYXRlbmN5UDkwSW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKFwiSW5zZXJ0TGF0ZW5jeVwiLCBNZXRyaWNTdGF0aXN0aWMuUDkwLCBcIkluc2VydFwiKTtcbiAgfVxuXG4gIG1ldHJpY1VwZGF0ZUxhdGVuY3lQOTBJbk1pbGxpcygpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoXCJVcGRhdGVMYXRlbmN5XCIsIE1ldHJpY1N0YXRpc3RpYy5QOTAsIFwiVXBkYXRlXCIpO1xuICB9XG5cbiAgbWV0cmljRGVsZXRlTGF0ZW5jeVA5MEluTWlsbGlzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcIkRlbGV0ZUxhdGVuY3lcIiwgTWV0cmljU3RhdGlzdGljLlA5MCwgXCJEZWxldGVcIik7XG4gIH1cblxuICBtZXRyaWNDb21taXRMYXRlbmN5UDkwSW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKFwiQ29tbWl0TGF0ZW5jeVwiLCBNZXRyaWNTdGF0aXN0aWMuUDkwLCBcIkNvbW1pdFwiKTtcbiAgfVxuXG4gIHByaXZhdGUgbWV0cmljKFxuICAgIG1ldHJpY05hbWU6IHN0cmluZyxcbiAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYyxcbiAgICBsYWJlbDogc3RyaW5nXG4gICkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuY3JlYXRlTWV0cmljKFxuICAgICAgbWV0cmljTmFtZSxcbiAgICAgIHN0YXRpc3RpYyxcbiAgICAgIGxhYmVsLFxuICAgICAgdGhpcy5kaW1lbnNpb25zTWFwLFxuICAgICAgdW5kZWZpbmVkLFxuICAgICAgUmRzTmFtZXNwYWNlXG4gICAgKTtcbiAgfVxufVxuIl19