import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, MetricWithAlarmSupport, Monitoring, MonitoringScope, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { RdsClusterMetricFactoryProps } from "./RdsClusterMetricFactory";
export interface RdsClusterMonitoringOptions extends BaseMonitoringProps {
    readonly addDiskSpaceUsageAlarm?: Record<string, UsageThreshold>;
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
}
export interface RdsClusterMonitoringProps extends RdsClusterMetricFactoryProps, RdsClusterMonitoringOptions {
}
export declare class RdsClusterMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly url?: string;
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly usageAnnotations: HorizontalAnnotation[];
    protected readonly connectionsMetric: MetricWithAlarmSupport;
    protected readonly diskSpaceUsageMetric: MetricWithAlarmSupport;
    protected readonly cpuUsageMetric: MetricWithAlarmSupport;
    protected readonly selectLatencyMetric: MetricWithAlarmSupport;
    protected readonly insertLatencyMetric: MetricWithAlarmSupport;
    protected readonly updateLatencyMetric: MetricWithAlarmSupport;
    protected readonly deleteLatencyMetric: MetricWithAlarmSupport;
    protected readonly commitLatencyMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: RdsClusterMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuAndDiskUsageWidget(width: number, height: number): GraphWidget;
    protected createConnectionsWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
}
