"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftClusterMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const RedshiftNamespace = "AWS/Redshift";
class RedshiftClusterMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            ClusterIdentifier: props.clusterIdentifier,
        };
    }
    metricTotalConnectionCount() {
        return this.metric("DatabaseConnections", common_1.MetricStatistic.SUM, "Connections");
    }
    metricAverageDiskSpaceUsageInPercent() {
        return this.metric("PercentageDiskSpaceUsed", common_1.MetricStatistic.AVERAGE, "Disk Usage");
    }
    metricAverageCpuUsageInPercent() {
        return this.metric("CPUUtilization", common_1.MetricStatistic.AVERAGE, "CPU Usage");
    }
    metricShortQueryDurationP90InMillis() {
        const sQueryLatency90 = this.metricQueryDuration("short", common_1.MetricStatistic.P90);
        // need to convert micros to millis
        return this.metricFactory.createMetricMath("sQueryLatency90 / 1000", { sQueryLatency90 }, "Short P90");
    }
    metricMediumQueryDurationP90InMillis() {
        const mQueryLatency90 = this.metricQueryDuration("medium", common_1.MetricStatistic.P90);
        // need to convert micros to millis
        return this.metricFactory.createMetricMath("mQueryLatency90 / 1000", { mQueryLatency90 }, "Medium P90");
    }
    metricLongQueryDurationP90InMillis() {
        const lQueryLatency90 = this.metricQueryDuration("long", common_1.MetricStatistic.P90);
        // need to convert micros to millis
        return this.metricFactory.createMetricMath("lQueryLatency90 / 1000", { lQueryLatency90 }, "Long P90");
    }
    metricMaintenanceModeEnabled() {
        return this.metric("MaintenanceMode", common_1.MetricStatistic.MAX, "Maintenance");
    }
    metricReadLatencyP90InMillis() {
        const readLatency = this.metric("ReadLatency", common_1.MetricStatistic.P90, "Read P90");
        // need to convert seconds to millis
        return this.metricFactory.createMetricMath("readLatency * 1000", { readLatency }, "Read P90");
    }
    metricWriteLatencyP90InMillis() {
        const writeLatency = this.metric("WriteLatency", common_1.MetricStatistic.P90, "Write P90");
        // need to convert seconds to millis
        return this.metricFactory.createMetricMath("writeLatency * 1000", { writeLatency }, "Write P90");
    }
    metricQueryDuration(latency, statistic) {
        const dimensions = { ...this.dimensionsMap, latency };
        return this.metricFactory.createMetric("QueryDuration", statistic, latency, dimensions, undefined, RedshiftNamespace);
    }
    metric(metricName, statistic, label) {
        return this.metricFactory.createMetric(metricName, statistic, label, this.dimensionsMap, undefined, RedshiftNamespace);
    }
}
exports.RedshiftClusterMetricFactory = RedshiftClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
RedshiftClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.RedshiftClusterMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUmVkc2hpZnRDbHVzdGVyTWV0cmljRmFjdG9yeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIlJlZHNoaWZ0Q2x1c3Rlck1ldHJpY0ZhY3RvcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSx5Q0FBOEQ7QUFFOUQsTUFBTSxpQkFBaUIsR0FBRyxjQUFjLENBQUM7QUFRekMsTUFBYSw0QkFBNEI7SUFJdkMsWUFDRSxhQUE0QixFQUM1QixLQUF3QztRQUV4QyxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQztRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHO1lBQ25CLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7U0FDM0MsQ0FBQztJQUNKLENBQUM7SUFFRCwwQkFBMEI7UUFDeEIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUNoQixxQkFBcUIsRUFDckIsd0JBQWUsQ0FBQyxHQUFHLEVBQ25CLGFBQWEsQ0FDZCxDQUFDO0lBQ0osQ0FBQztJQUVELG9DQUFvQztRQUNsQyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQ2hCLHlCQUF5QixFQUN6Qix3QkFBZSxDQUFDLE9BQU8sRUFDdkIsWUFBWSxDQUNiLENBQUM7SUFDSixDQUFDO0lBRUQsOEJBQThCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsRUFBRSx3QkFBZSxDQUFDLE9BQU8sRUFBRSxXQUFXLENBQUMsQ0FBQztJQUM3RSxDQUFDO0lBRUQsbUNBQW1DO1FBQ2pDLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyxtQkFBbUIsQ0FDOUMsT0FBTyxFQUNQLHdCQUFlLENBQUMsR0FBRyxDQUNwQixDQUFDO1FBQ0YsbUNBQW1DO1FBQ25DLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FDeEMsd0JBQXdCLEVBQ3hCLEVBQUUsZUFBZSxFQUFFLEVBQ25CLFdBQVcsQ0FDWixDQUFDO0lBQ0osQ0FBQztJQUVELG9DQUFvQztRQUNsQyxNQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQzlDLFFBQVEsRUFDUix3QkFBZSxDQUFDLEdBQUcsQ0FDcEIsQ0FBQztRQUNGLG1DQUFtQztRQUNuQyxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsZ0JBQWdCLENBQ3hDLHdCQUF3QixFQUN4QixFQUFFLGVBQWUsRUFBRSxFQUNuQixZQUFZLENBQ2IsQ0FBQztJQUNKLENBQUM7SUFFRCxrQ0FBa0M7UUFDaEMsTUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUM5QyxNQUFNLEVBQ04sd0JBQWUsQ0FBQyxHQUFHLENBQ3BCLENBQUM7UUFDRixtQ0FBbUM7UUFDbkMsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUN4Qyx3QkFBd0IsRUFDeEIsRUFBRSxlQUFlLEVBQUUsRUFDbkIsVUFBVSxDQUNYLENBQUM7SUFDSixDQUFDO0lBRUQsNEJBQTRCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSx3QkFBZSxDQUFDLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBRUQsNEJBQTRCO1FBQzFCLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQzdCLGFBQWEsRUFDYix3QkFBZSxDQUFDLEdBQUcsRUFDbkIsVUFBVSxDQUNYLENBQUM7UUFDRixvQ0FBb0M7UUFDcEMsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUN4QyxvQkFBb0IsRUFDcEIsRUFBRSxXQUFXLEVBQUUsRUFDZixVQUFVLENBQ1gsQ0FBQztJQUNKLENBQUM7SUFFRCw2QkFBNkI7UUFDM0IsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FDOUIsY0FBYyxFQUNkLHdCQUFlLENBQUMsR0FBRyxFQUNuQixXQUFXLENBQ1osQ0FBQztRQUNGLG9DQUFvQztRQUNwQyxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsZ0JBQWdCLENBQ3hDLHFCQUFxQixFQUNyQixFQUFFLFlBQVksRUFBRSxFQUNoQixXQUFXLENBQ1osQ0FBQztJQUNKLENBQUM7SUFFTyxtQkFBbUIsQ0FDekIsT0FBMEIsRUFDMUIsU0FBMEI7UUFFMUIsTUFBTSxVQUFVLEdBQUcsRUFBRSxHQUFHLElBQUksQ0FBQyxhQUFhLEVBQUUsT0FBTyxFQUFFLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FDcEMsZUFBZSxFQUNmLFNBQVMsRUFDVCxPQUFPLEVBQ1AsVUFBVSxFQUNWLFNBQVMsRUFDVCxpQkFBaUIsQ0FDbEIsQ0FBQztJQUNKLENBQUM7SUFFTyxNQUFNLENBQ1osVUFBa0IsRUFDbEIsU0FBMEIsRUFDMUIsS0FBYTtRQUViLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQ3BDLFVBQVUsRUFDVixTQUFTLEVBQ1QsS0FBSyxFQUNMLElBQUksQ0FBQyxhQUFhLEVBQ2xCLFNBQVMsRUFDVCxpQkFBaUIsQ0FDbEIsQ0FBQztJQUNKLENBQUM7O0FBcklILG9FQXNJQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERpbWVuc2lvbnNNYXAgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcblxuaW1wb3J0IHsgTWV0cmljRmFjdG9yeSwgTWV0cmljU3RhdGlzdGljIH0gZnJvbSBcIi4uLy4uL2NvbW1vblwiO1xuXG5jb25zdCBSZWRzaGlmdE5hbWVzcGFjZSA9IFwiQVdTL1JlZHNoaWZ0XCI7XG5cbnR5cGUgUXVlcnlMYXRlbmN5Q2xhc3MgPSBcInNob3J0XCIgfCBcIm1lZGl1bVwiIHwgXCJsb25nXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVkc2hpZnRDbHVzdGVyTWV0cmljRmFjdG9yeVByb3BzIHtcbiAgcmVhZG9ubHkgY2x1c3RlcklkZW50aWZpZXI6IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFJlZHNoaWZ0Q2x1c3Rlck1ldHJpY0ZhY3Rvcnkge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgbWV0cmljRmFjdG9yeTogTWV0cmljRmFjdG9yeTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGRpbWVuc2lvbnNNYXA6IERpbWVuc2lvbnNNYXA7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgbWV0cmljRmFjdG9yeTogTWV0cmljRmFjdG9yeSxcbiAgICBwcm9wczogUmVkc2hpZnRDbHVzdGVyTWV0cmljRmFjdG9yeVByb3BzXG4gICkge1xuICAgIHRoaXMubWV0cmljRmFjdG9yeSA9IG1ldHJpY0ZhY3Rvcnk7XG4gICAgdGhpcy5kaW1lbnNpb25zTWFwID0ge1xuICAgICAgQ2x1c3RlcklkZW50aWZpZXI6IHByb3BzLmNsdXN0ZXJJZGVudGlmaWVyLFxuICAgIH07XG4gIH1cblxuICBtZXRyaWNUb3RhbENvbm5lY3Rpb25Db3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoXG4gICAgICBcIkRhdGFiYXNlQ29ubmVjdGlvbnNcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5TVU0sXG4gICAgICBcIkNvbm5lY3Rpb25zXCJcbiAgICApO1xuICB9XG5cbiAgbWV0cmljQXZlcmFnZURpc2tTcGFjZVVzYWdlSW5QZXJjZW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcbiAgICAgIFwiUGVyY2VudGFnZURpc2tTcGFjZVVzZWRcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5BVkVSQUdFLFxuICAgICAgXCJEaXNrIFVzYWdlXCJcbiAgICApO1xuICB9XG5cbiAgbWV0cmljQXZlcmFnZUNwdVVzYWdlSW5QZXJjZW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYyhcIkNQVVV0aWxpemF0aW9uXCIsIE1ldHJpY1N0YXRpc3RpYy5BVkVSQUdFLCBcIkNQVSBVc2FnZVwiKTtcbiAgfVxuXG4gIG1ldHJpY1Nob3J0UXVlcnlEdXJhdGlvblA5MEluTWlsbGlzKCkge1xuICAgIGNvbnN0IHNRdWVyeUxhdGVuY3k5MCA9IHRoaXMubWV0cmljUXVlcnlEdXJhdGlvbihcbiAgICAgIFwic2hvcnRcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5QOTBcbiAgICApO1xuICAgIC8vIG5lZWQgdG8gY29udmVydCBtaWNyb3MgdG8gbWlsbGlzXG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWNNYXRoKFxuICAgICAgXCJzUXVlcnlMYXRlbmN5OTAgLyAxMDAwXCIsXG4gICAgICB7IHNRdWVyeUxhdGVuY3k5MCB9LFxuICAgICAgXCJTaG9ydCBQOTBcIlxuICAgICk7XG4gIH1cblxuICBtZXRyaWNNZWRpdW1RdWVyeUR1cmF0aW9uUDkwSW5NaWxsaXMoKSB7XG4gICAgY29uc3QgbVF1ZXJ5TGF0ZW5jeTkwID0gdGhpcy5tZXRyaWNRdWVyeUR1cmF0aW9uKFxuICAgICAgXCJtZWRpdW1cIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5QOTBcbiAgICApO1xuICAgIC8vIG5lZWQgdG8gY29udmVydCBtaWNyb3MgdG8gbWlsbGlzXG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWNNYXRoKFxuICAgICAgXCJtUXVlcnlMYXRlbmN5OTAgLyAxMDAwXCIsXG4gICAgICB7IG1RdWVyeUxhdGVuY3k5MCB9LFxuICAgICAgXCJNZWRpdW0gUDkwXCJcbiAgICApO1xuICB9XG5cbiAgbWV0cmljTG9uZ1F1ZXJ5RHVyYXRpb25QOTBJbk1pbGxpcygpIHtcbiAgICBjb25zdCBsUXVlcnlMYXRlbmN5OTAgPSB0aGlzLm1ldHJpY1F1ZXJ5RHVyYXRpb24oXG4gICAgICBcImxvbmdcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5QOTBcbiAgICApO1xuICAgIC8vIG5lZWQgdG8gY29udmVydCBtaWNyb3MgdG8gbWlsbGlzXG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWNNYXRoKFxuICAgICAgXCJsUXVlcnlMYXRlbmN5OTAgLyAxMDAwXCIsXG4gICAgICB7IGxRdWVyeUxhdGVuY3k5MCB9LFxuICAgICAgXCJMb25nIFA5MFwiXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY01haW50ZW5hbmNlTW9kZUVuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKFwiTWFpbnRlbmFuY2VNb2RlXCIsIE1ldHJpY1N0YXRpc3RpYy5NQVgsIFwiTWFpbnRlbmFuY2VcIik7XG4gIH1cblxuICBtZXRyaWNSZWFkTGF0ZW5jeVA5MEluTWlsbGlzKCkge1xuICAgIGNvbnN0IHJlYWRMYXRlbmN5ID0gdGhpcy5tZXRyaWMoXG4gICAgICBcIlJlYWRMYXRlbmN5XCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuUDkwLFxuICAgICAgXCJSZWFkIFA5MFwiXG4gICAgKTtcbiAgICAvLyBuZWVkIHRvIGNvbnZlcnQgc2Vjb25kcyB0byBtaWxsaXNcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpY01hdGgoXG4gICAgICBcInJlYWRMYXRlbmN5ICogMTAwMFwiLFxuICAgICAgeyByZWFkTGF0ZW5jeSB9LFxuICAgICAgXCJSZWFkIFA5MFwiXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY1dyaXRlTGF0ZW5jeVA5MEluTWlsbGlzKCkge1xuICAgIGNvbnN0IHdyaXRlTGF0ZW5jeSA9IHRoaXMubWV0cmljKFxuICAgICAgXCJXcml0ZUxhdGVuY3lcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5QOTAsXG4gICAgICBcIldyaXRlIFA5MFwiXG4gICAgKTtcbiAgICAvLyBuZWVkIHRvIGNvbnZlcnQgc2Vjb25kcyB0byBtaWxsaXNcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpY01hdGgoXG4gICAgICBcIndyaXRlTGF0ZW5jeSAqIDEwMDBcIixcbiAgICAgIHsgd3JpdGVMYXRlbmN5IH0sXG4gICAgICBcIldyaXRlIFA5MFwiXG4gICAgKTtcbiAgfVxuXG4gIHByaXZhdGUgbWV0cmljUXVlcnlEdXJhdGlvbihcbiAgICBsYXRlbmN5OiBRdWVyeUxhdGVuY3lDbGFzcyxcbiAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpY1xuICApIHtcbiAgICBjb25zdCBkaW1lbnNpb25zID0geyAuLi50aGlzLmRpbWVuc2lvbnNNYXAsIGxhdGVuY3kgfTtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpYyhcbiAgICAgIFwiUXVlcnlEdXJhdGlvblwiLFxuICAgICAgc3RhdGlzdGljLFxuICAgICAgbGF0ZW5jeSxcbiAgICAgIGRpbWVuc2lvbnMsXG4gICAgICB1bmRlZmluZWQsXG4gICAgICBSZWRzaGlmdE5hbWVzcGFjZVxuICAgICk7XG4gIH1cblxuICBwcml2YXRlIG1ldHJpYyhcbiAgICBtZXRyaWNOYW1lOiBzdHJpbmcsXG4gICAgc3RhdGlzdGljOiBNZXRyaWNTdGF0aXN0aWMsXG4gICAgbGFiZWw6IHN0cmluZ1xuICApIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpYyhcbiAgICAgIG1ldHJpY05hbWUsXG4gICAgICBzdGF0aXN0aWMsXG4gICAgICBsYWJlbCxcbiAgICAgIHRoaXMuZGltZW5zaW9uc01hcCxcbiAgICAgIHVuZGVmaW5lZCxcbiAgICAgIFJlZHNoaWZ0TmFtZXNwYWNlXG4gICAgKTtcbiAgfVxufVxuIl19