import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, MetricWithAlarmSupport, Monitoring, MonitoringScope, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { RedshiftClusterMetricFactoryProps } from "./RedshiftClusterMetricFactory";
export interface RedshiftClusterMonitoringOptions extends BaseMonitoringProps {
    readonly addDiskSpaceUsageAlarm?: Record<string, UsageThreshold>;
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
}
export interface RedshiftClusterMonitoringProps extends RedshiftClusterMetricFactoryProps, RedshiftClusterMonitoringOptions {
}
export declare class RedshiftClusterMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly url?: string;
    protected readonly usageAlarmFactory: UsageAlarmFactory;
    protected readonly usageAnnotations: HorizontalAnnotation[];
    protected readonly connectionsMetric: MetricWithAlarmSupport;
    protected readonly diskSpaceUsageMetric: MetricWithAlarmSupport;
    protected readonly cpuUsageMetric: MetricWithAlarmSupport;
    protected readonly shortQueryDurationMetric: MetricWithAlarmSupport;
    protected readonly mediumQueryDurationMetric: MetricWithAlarmSupport;
    protected readonly longQueryDurationMetric: MetricWithAlarmSupport;
    protected readonly readLatencyMetric: MetricWithAlarmSupport;
    protected readonly writeLatencyMetric: MetricWithAlarmSupport;
    protected readonly maintenanceModeMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: RedshiftClusterMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createCpuAndDiskUsageWidget(width: number, height: number): GraphWidget;
    protected createConnectionsWidget(width: number, height: number): GraphWidget;
    protected createQueryDurationWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createMaintenanceWidget(width: number, height: number): GraphWidget;
}
