"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketMetricFactory = exports.StorageType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/S3";
var StorageType;
(function (StorageType) {
    StorageType["DEEP_ARCHIVE_OBJECT_OVERHEAD"] = "DeepArchiveObjectOverhead";
    StorageType["DEEP_ARCHIVE_S3_OBJECT_OVERHEAD"] = "DeepArchiveS3ObjectOverhead";
    StorageType["DEEP_ARCHIVE_STAGING_STORAGE"] = "DeepArchiveStagingStorage";
    StorageType["DEEP_ARCHIVE_STORAGE"] = "DeepArchiveStorage";
    StorageType["GLACIER_OBJECT_OVERHEAD"] = "GlacierObjectOverhead";
    StorageType["GLACIER_S3_OBJECT_OVERHEAD"] = "GlacierS3ObjectOverhead";
    StorageType["GLACIER_STAGING_STORAGE"] = "GlacierStagingStorage";
    StorageType["GLACIER_STORAGE"] = "GlacierStorage";
    StorageType["INTELLIGENT_TIERING_FA_STORAGE"] = "IntelligentTieringFAStorage";
    StorageType["INTELLIGENT_TIERING_IA_STORAGE"] = "IntelligentTieringIAStorage";
    StorageType["ONE_ZONE_IA_SIZE_OVERHEAD"] = "OneZoneIASizeOverhead";
    StorageType["ONE_ZONE_IA_STORAGE"] = "OneZoneIAStorage";
    StorageType["REDUCED_REDUNDANCY_STORAGE"] = "ReducedRedundancyStorage";
    StorageType["STANDARD_IA_SIZE_OVERHEAD"] = "StandardIASizeOverhead";
    StorageType["STANDARD_IA_STORAGE"] = "StandardIAStorage";
    StorageType["STANDARD_STORAGE"] = "StandardStorage";
})(StorageType = exports.StorageType || (exports.StorageType = {}));
class S3BucketMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.props = props;
    }
    metricBucketSizeBytes() {
        var _b;
        return this.metricFactory.createMetric("BucketSizeBytes", common_1.MetricStatistic.AVERAGE, "BucketSizeBytes", {
            BucketName: this.props.bucket.bucketName,
            StorageType: (_b = this.props.storageType) !== null && _b !== void 0 ? _b : StorageType.STANDARD_STORAGE,
        }, undefined, Namespace);
    }
    metricNumberOfObjects() {
        return this.metricFactory.createMetric("NumberOfObjects", common_1.MetricStatistic.AVERAGE, "NumberOfObjects", {
            BucketName: this.props.bucket.bucketName,
            StorageType: "AllStorageTypes",
        }, undefined, Namespace);
    }
}
exports.S3BucketMetricFactory = S3BucketMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
S3BucketMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.S3BucketMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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