"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const S3BucketMetricFactory_1 = require("./S3BucketMetricFactory");
class S3BucketMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const fallbackConstructName = this.getBucketName(props.bucket);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.bucket,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.url = scope
            .createAwsConsoleUrlFactory()
            .getS3BucketUrl(props.bucket.bucketName);
        const metricFactory = new S3BucketMetricFactory_1.S3BucketMetricFactory(this.createMetricFactory(), props);
        this.bucketSizeBytesMetric = metricFactory.metricBucketSizeBytes();
        this.numberOfObjectsMetric = metricFactory.metricNumberOfObjects();
    }
    summaryWidgets() {
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "S3 Bucket",
                title: this.title,
                goToLinkUrl: this.url,
            }),
            // Size
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Bucket Size",
                left: [this.bucketSizeBytesMetric],
                leftYAxis: common_1.SizeAxisBytesFromZero,
            }),
            // Objects
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Object Count",
                left: [this.numberOfObjectsMetric],
                leftYAxis: common_1.CountAxisFromZero,
            }),
        ];
    }
    widgets() {
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "S3 Bucket",
                title: this.title,
                goToLinkUrl: this.url,
            }),
            // Size
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Bucket Size",
                left: [this.bucketSizeBytesMetric],
                leftYAxis: common_1.SizeAxisBytesFromZero,
            }),
            // Objects
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Object Count",
                left: [this.numberOfObjectsMetric],
                leftYAxis: common_1.CountAxisFromZero,
            }),
        ];
    }
    getBucketName(bucket) {
        var _b;
        // try to take the name (if specified) instead of token
        return (_b = bucket.node.defaultChild) === null || _b === void 0 ? void 0 : _b.bucketName;
    }
}
exports.S3BucketMonitoring = S3BucketMonitoring;
_a = JSII_RTTI_SYMBOL_1;
S3BucketMonitoring[_a] = { fqn: "cdk-monitoring-constructs.S3BucketMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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